@extends('layouts.app')

@section('title', 'Análise Regional')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800 flex items-center">
                    <i class="fas fa-globe-africa mr-3 text-purple-600"></i>
                    Análise Regional Hidrológica
                </h1>
                <p class="text-gray-600 mt-2">Visão consolidada da situação hídrica regional</p>
            </div>
            <div class="text-right">
                <div class="text-3xl font-bold text-purple-600">{{ $barragens_stats->count() + count($precipitacao_regional) }}</div>
                <div class="text-sm text-gray-500">Pontos de Monitoramento</div>
            </div>
        </div>
    </div>

    <!-- Resumo Executivo -->
    <div class="bg-white rounded-lg shadow-lg p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-6">Resumo Executivo</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            @php
                $barragens_em_alerta = $barragens_stats->where('status', 'alerta')->count();
                $media_enchimento = $barragens_stats->avg('percentagem');
                $volume_total = $barragens_stats->sum('volume');
                $precipitacao_media = $precipitacao_regional->avg('media_precipitacao');
            @endphp

            <!-- Status Geral das Barragens -->
            <div class="bg-gradient-to-br from-blue-50 to-indigo-50 rounded-lg p-6 border border-blue-200">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-blue-500 rounded-lg flex items-center justify-center">
                            <i class="fas fa-water text-white text-xl"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-blue-600 font-medium">Enchimento Médio</p>
                        <p class="text-2xl font-bold text-blue-900">{{ number_format($media_enchimento, 1) }}%</p>
                        <p class="text-xs text-blue-600">{{ $barragens_stats->count() }} barragens</p>
                    </div>
                </div>
            </div>

            <!-- Volume Total -->
            <div class="bg-gradient-to-br from-green-50 to-emerald-50 rounded-lg p-6 border border-green-200">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-green-500 rounded-lg flex items-center justify-center">
                            <i class="fas fa-chart-bar text-white text-xl"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-green-600 font-medium">Volume Armazenado</p>
                        <p class="text-2xl font-bold text-green-900">{{ number_format($volume_total, 0) }}</p>
                        <p class="text-xs text-green-600">Mm³ total</p>
                    </div>
                </div>
            </div>

            <!-- Alertas -->
            <div class="bg-gradient-to-br from-{{ $barragens_em_alerta > 0 ? 'red' : 'gray' }}-50 to-{{ $barragens_em_alerta > 0 ? 'orange' : 'gray' }}-50 rounded-lg p-6 border border-{{ $barragens_em_alerta > 0 ? 'red' : 'gray' }}-200">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-{{ $barragens_em_alerta > 0 ? 'red' : 'gray' }}-500 rounded-lg flex items-center justify-center">
                            <i class="fas fa-exclamation-triangle text-white text-xl"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-{{ $barragens_em_alerta > 0 ? 'red' : 'gray' }}-600 font-medium">Barragens em Alerta</p>
                        <p class="text-2xl font-bold text-{{ $barragens_em_alerta > 0 ? 'red' : 'gray' }}-900">{{ $barragens_em_alerta }}</p>
                        <p class="text-xs text-{{ $barragens_em_alerta > 0 ? 'red' : 'gray' }}-600">{{ $barragens_stats->count() - $barragens_em_alerta }} normais</p>
                    </div>
                </div>
            </div>

            <!-- Precipitação Média -->
            <div class="bg-gradient-to-br from-cyan-50 to-blue-50 rounded-lg p-6 border border-cyan-200">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-cyan-500 rounded-lg flex items-center justify-center">
                            <i class="fas fa-cloud-rain text-white text-xl"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-cyan-600 font-medium">Precipitação Média</p>
                        <p class="text-2xl font-bold text-cyan-900">{{ number_format($precipitacao_media, 1) }}</p>
                        <p class="text-xs text-cyan-600">mm (últimos 30 dias)</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Gráficos Principais -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Situação das Barragens -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">Situação das Barragens</h3>
            <div class="h-64">
                <canvas id="grafico-barragens"></canvas>
            </div>
        </div>

        <!-- Precipitação Regional -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">Precipitação Regional (30 dias)</h3>
            <div class="h-64">
                <canvas id="grafico-precipitacao"></canvas>
            </div>
        </div>
    </div>

    <!-- Mapa de Status -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Mapa de Status das Barragens</h3>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
            @foreach($barragens_stats as $barragem)
            <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow">
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-medium text-gray-900 truncate">{{ $barragem['nome'] }}</h4>
                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                        @if($barragem['status'] == 'normal') bg-green-100 text-green-800
                        @elseif($barragem['status'] == 'alerta') bg-yellow-100 text-yellow-800
                        @else bg-red-100 text-red-800 @endif">
                        {{ ucfirst($barragem['status']) }}
                    </span>
                </div>

                <!-- Barra de Enchimento -->
                <div class="mb-2">
                    <div class="flex justify-between text-xs text-gray-500 mb-1">
                        <span>Enchimento</span>
                        <span>{{ number_format($barragem['percentagem'], 1) }}%</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-2">
                        <div class="
                            @if($barragem['percentagem'] >= 80) bg-green-600
                            @elseif($barragem['percentagem'] >= 50) bg-blue-600
                            @elseif($barragem['percentagem'] >= 30) bg-yellow-600
                            @else bg-red-600 @endif
                            h-2 rounded-full transition-all duration-300"
                             style="width: {{ min($barragem['percentagem'], 100) }}%"></div>
                    </div>
                </div>

                <!-- Dados -->
                <div class="grid grid-cols-2 gap-2 text-xs text-gray-600">
                    <div>
                        <span class="block font-medium">Volume:</span>
                        <span>{{ number_format($barragem['volume'], 1) }} Mm³</span>
                    </div>
                    <div>
                        <span class="block font-medium">Cota:</span>
                        <span>{{ number_format($barragem['cota'], 2) }} m</span>
                    </div>
                </div>

                <!-- Link -->
                <div class="mt-3 pt-2 border-t border-gray-100">
                    @if(isset($barragem['id']))
                        <a href="{{ route('charts.barragem-detail', ['barragem' => $barragem['id']]) }}"
                           class="text-xs text-blue-600 hover:text-blue-800 font-medium">
                            <i class="fas fa-chart-area mr-1"></i>Ver Detalhes
                        </a>
                    @else
                        <span class="text-xs text-gray-400">
                            <i class="fas fa-chart-area mr-1"></i>Dados não disponíveis
                        </span>
                    @endif
                </div>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Análise por Bacia Hidrográfica -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Análise por Bacia Hidrográfica</h3>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Bacia</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Barragens</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Estações</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Enchimento Médio</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Volume Total</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @php
                        $bacias = \App\Models\BaciaHidrografica::withCount(['barragens', 'estacoes'])->get();
                    @endphp
                    @foreach($bacias as $bacia)
                    @php
                        $barragens_bacia = $bacia->barragens()->with('ultima_leitura')->get();
                        $enchimento_bacia = $barragens_bacia->filter(fn($b) => $b->ultima_leitura)->avg(fn($b) => $b->ultima_leitura->percentagem_enchimento ?? 0);
                        $volume_bacia = $barragens_bacia->filter(fn($b) => $b->ultima_leitura)->sum(fn($b) => $b->ultima_leitura->volume_actual ?? 0);
                        $status_bacia = $enchimento_bacia >= 70 ? 'Bom' : ($enchimento_bacia >= 40 ? 'Regular' : 'Crítico');
                    @endphp
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900">{{ $bacia->nome }}</div>
                            <div class="text-sm text-gray-500">{{ $bacia->codigo ?? 'N/A' }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                            {{ $bacia->barragens_count }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                            {{ $bacia->estacoes_count }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="w-16 bg-gray-200 rounded-full h-2 mr-2">
                                    <div class="bg-blue-600 h-2 rounded-full" style="width: {{ $enchimento_bacia }}%"></div>
                                </div>
                                <span class="text-sm">{{ number_format($enchimento_bacia, 1) }}%</span>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                            {{ number_format($volume_bacia, 1) }} Mm³
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                @if($status_bacia == 'Bom') bg-green-100 text-green-800
                                @elseif($status_bacia == 'Regular') bg-yellow-100 text-yellow-800
                                @else bg-red-100 text-red-800 @endif">
                                {{ $status_bacia }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Recomendações -->
    <div class="bg-gradient-to-r from-yellow-50 to-orange-50 border border-yellow-200 rounded-lg p-6">
        <h3 class="text-lg font-semibold text-yellow-800 mb-4">
            <i class="fas fa-lightbulb mr-2"></i>
            Recomendações Baseadas na Análise Atual
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="bg-white rounded-lg p-4">
                <h4 class="font-medium text-gray-900 mb-2">Gestão de Recursos Hídricos</h4>
                <ul class="text-sm text-gray-700 space-y-1">
                    @if($media_enchimento < 30)
                        <li class="flex items-center"><i class="fas fa-exclamation-triangle text-red-500 mr-2"></i>Implementar medidas de conservação de água</li>
                        <li class="flex items-center"><i class="fas fa-tint text-blue-500 mr-2"></i>Monitorar consumos e otimizar distribuição</li>
                    @elseif($media_enchimento > 80)
                        <li class="flex items-center"><i class="fas fa-check-circle text-green-500 mr-2"></i>Condições hídricas favoráveis</li>
                        <li class="flex items-center"><i class="fas fa-eye text-blue-500 mr-2"></i>Manter vigilância para prevenção de cheias</li>
                    @else
                        <li class="flex items-center"><i class="fas fa-balance-scale text-blue-500 mr-2"></i>Manter equilíbrio na gestão hídrica</li>
                        <li class="flex items-center"><i class="fas fa-chart-line text-green-500 mr-2"></i>Continuar monitoramento regular</li>
                    @endif
                </ul>
            </div>
            <div class="bg-white rounded-lg p-4">
                <h4 class="font-medium text-gray-900 mb-2">Monitoramento</h4>
                <ul class="text-sm text-gray-700 space-y-1">
                    <li class="flex items-center"><i class="fas fa-clock text-blue-500 mr-2"></i>Manter frequência de leituras</li>
                    <li class="flex items-center"><i class="fas fa-satellite-dish text-green-500 mr-2"></i>Verificar funcionamento das estações</li>
                    <li class="flex items-center"><i class="fas fa-bell text-yellow-500 mr-2"></i>Configurar alertas automáticos</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Gráfico de Situação das Barragens
    const ctxBarragens = document.getElementById('grafico-barragens').getContext('2d');
    const barragensData = @json($barragens_stats->values());

    new Chart(ctxBarragens, {
        type: 'doughnut',
        data: {
            labels: barragensData.map(b => b.nome),
            datasets: [{
                data: barragensData.map(b => b.percentagem),
                backgroundColor: [
                    '#3B82F6', '#10B981', '#F59E0B', '#EF4444', '#8B5CF6',
                    '#06B6D4', '#F97316', '#84CC16', '#EC4899', '#6366F1'
                ].slice(0, barragensData.length),
                borderWidth: 2,
                borderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                title: {
                    display: true,
                    text: 'Percentagem de Enchimento por Barragem'
                },
                legend: {
                    position: 'bottom',
                    labels: {
                        boxWidth: 12,
                        font: {
                            size: 11
                        }
                    }
                }
            }
        }
    });

    // Gráfico de Precipitação Regional
    const ctxPrecipitacao = document.getElementById('grafico-precipitacao').getContext('2d');
    const precipitacaoData = @json($precipitacao_regional->values());

    new Chart(ctxPrecipitacao, {
        type: 'line',
        data: {
            labels: precipitacaoData.map(p => new Date(p.data_leitura).toLocaleDateString('pt-PT')),
            datasets: [{
                label: 'Precipitação Média Regional (mm)',
                data: precipitacaoData.map(p => parseFloat(p.media_precipitacao) || 0),
                borderColor: '#06B6D4',
                backgroundColor: '#06B6D420',
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value + ' mm';
                        }
                    }
                }
            }
        }
    });
});
</script>
@endsection