<!-- Aba: Dados Meteorológicos -->
<div id="dados-meteorologicos" class="tab-content p-6 space-y-6" style="display: none;">
    @if(in_array($estacao->tipo, ['meteorologica', 'climatologica']))
    <div class="bg-gradient-to-r from-purple-50 to-pink-50 rounded-lg p-6">
        <h4 class="font-semibold text-purple-900 mb-4 flex items-center">
            <i class="fas fa-thermometer-half mr-2"></i>
            Dados de Temperatura
        </h4>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Temperatura Máxima (°C) *
                </label>
                <input type="number" step="0.1" name="temperatura_max" id="temp_max"
                       placeholder="Ex: 28.5"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-purple-500 focus:ring-purple-500"
                       onchange="validarTemperaturas()">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Temperatura Mínima (°C) *
                </label>
                <input type="number" step="0.1" name="temperatura_min" id="temp_min"
                       placeholder="Ex: 18.2"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-purple-500 focus:ring-purple-500"
                       onchange="validarTemperaturas()">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Temperatura Atual (°C)
                </label>
                <input type="number" step="0.1" name="temperatura_atual"
                       placeholder="Ex: 24.1"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-purple-500 focus:ring-purple-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Amplitude Térmica (°C)
                </label>
                <input type="number" step="0.1" id="amplitude_termica" readonly
                       class="w-full border-gray-300 rounded-md shadow-sm bg-gray-50">
            </div>
        </div>
    </div>

    <div class="bg-gradient-to-r from-cyan-50 to-blue-50 rounded-lg p-6">
        <h4 class="font-semibold text-cyan-900 mb-4 flex items-center">
            <i class="fas fa-wind mr-2"></i>
            Dados Atmosféricos
        </h4>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Humidade Relativa (%)
                </label>
                <input type="number" step="0.1" min="0" max="100" name="humidade_relativa"
                       placeholder="Ex: 65.5"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Pressão Atmosférica (hPa)
                </label>
                <input type="number" step="0.1" name="pressao_atmosferica"
                       placeholder="Ex: 1013.2"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Velocidade do Vento (km/h)
                </label>
                <input type="number" step="0.1" name="velocidade_vento"
                       placeholder="Ex: 12.5"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Direção do Vento
                </label>
                <select name="direcao_vento"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
                    <option value="">Selecionar</option>
                    <option value="N">Norte (N)</option>
                    <option value="NE">Nordeste (NE)</option>
                    <option value="E">Este (E)</option>
                    <option value="SE">Sudeste (SE)</option>
                    <option value="S">Sul (S)</option>
                    <option value="SW">Sudoeste (SW)</option>
                    <option value="W">Oeste (W)</option>
                    <option value="NW">Noroeste (NW)</option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Evaporação (mm)
                </label>
                <input type="number" step="0.1" name="evaporacao"
                       placeholder="Ex: 4.2"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Insolação (horas)
                </label>
                <input type="number" step="0.1" min="0" max="24" name="insolacao"
                       placeholder="Ex: 8.5"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
            </div>
        </div>
    </div>
    @endif
</div>

<!-- Aba: Validação & Qualidade -->
<div id="validacao-qualidade" class="tab-content p-6 space-y-6" style="display: none;">
    <div class="bg-yellow-50 rounded-lg p-6">
        <h4 class="font-semibold text-yellow-900 mb-4 flex items-center">
            <i class="fas fa-shield-alt mr-2"></i>
            Controle de Qualidade dos Dados
        </h4>

        <div id="validacao-resultados" class="space-y-4">
            <!-- Resultados de validação serão inseridos aqui via JavaScript -->
            <div class="bg-white rounded-lg p-4 border border-yellow-200">
                <p class="text-gray-600 text-center">
                    <i class="fas fa-info-circle mr-2"></i>
                    Preencha os dados principais para ver a validação automática
                </p>
            </div>
        </div>

        <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Status da Leitura
                </label>
                <select name="status_qualidade"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-yellow-500 focus:ring-yellow-500">
                    <option value="validado">Validado</option>
                    <option value="provisorio">Provisório</option>
                    <option value="duvidoso">Duvidoso</option>
                    <option value="rejeitado">Rejeitado</option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Confiabilidade (%)
                </label>
                <input type="number" min="0" max="100" name="confiabilidade" value="100"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-yellow-500 focus:ring-yellow-500">
            </div>
        </div>
    </div>
</div>

<!-- Aba: Histórico & Comparação -->
<div id="historico-comparacao" class="tab-content p-6 space-y-6" style="display: none;">
    <div class="bg-indigo-50 rounded-lg p-6">
        <h4 class="font-semibold text-indigo-900 mb-4 flex items-center">
            <i class="fas fa-chart-area mr-2"></i>
            Comparação com Dados Históricos
        </h4>

        <div id="comparacao-historica" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <!-- Será preenchido via JavaScript -->
            <div class="bg-white rounded-lg p-4 border border-indigo-200">
                <div class="text-center">
                    <i class="fas fa-chart-line text-3xl text-indigo-400 mb-3"></i>
                    <p class="text-gray-600">Carregando dados históricos...</p>
                </div>
            </div>
            <div class="bg-white rounded-lg p-4 border border-indigo-200">
                <div class="text-center">
                    <i class="fas fa-calendar text-3xl text-indigo-400 mb-3"></i>
                    <p class="text-gray-600">Comparação mensal</p>
                </div>
            </div>
            <div class="bg-white rounded-lg p-4 border border-indigo-200">
                <div class="text-center">
                    <i class="fas fa-trending-up text-3xl text-indigo-400 mb-3"></i>
                    <p class="text-gray-600">Tendências anuais</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Aba: Importação -->
<div id="importacao" class="tab-content p-6 space-y-6" style="display: none;">
    <div class="bg-emerald-50 rounded-lg p-6">
        <h4 class="font-semibold text-emerald-900 mb-4 flex items-center">
            <i class="fas fa-file-import mr-2"></i>
            Importação de Dados
        </h4>

        <div class="space-y-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Arquivo Excel/CSV
                </label>
                <input type="file" name="arquivo_importacao" accept=".xlsx,.xls,.csv"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-emerald-500 focus:ring-emerald-500"
                       onchange="processarArquivoImportacao(this)">
                <small class="text-gray-500">Formatos suportados: .xlsx, .xls, .csv</small>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Tipo de Template
                    </label>
                    <select class="w-full border-gray-300 rounded-md shadow-sm focus:border-emerald-500 focus:ring-emerald-500">
                        <option value="moderno">Template Moderno</option>
                        <option value="legado">Template Legado (Excel)</option>
                        <option value="customizado">Personalizado</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Ações Rápidas
                    </label>
                    <div class="flex space-x-2">
                        <button type="button" class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-2 rounded text-sm">
                            <i class="fas fa-download mr-1"></i>
                            Baixar Template
                        </button>
                        <button type="button" class="bg-purple-600 hover:bg-purple-700 text-white px-3 py-2 rounded text-sm">
                            <i class="fas fa-eye mr-1"></i>
                            Preview
                        </button>
                    </div>
                </div>
            </div>

            <div id="preview-importacao" class="hidden bg-white rounded-lg border p-4">
                <h5 class="font-medium text-gray-900 mb-3">Preview dos Dados</h5>
                <div id="dados-preview" class="overflow-x-auto">
                    <!-- Tabela de preview será inserida aqui -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function validarTemperaturas() {
    const tempMax = parseFloat(document.getElementById('temp_max')?.value || 0);
    const tempMin = parseFloat(document.getElementById('temp_min')?.value || 0);

    if (tempMax > 0 && tempMin > 0 && tempMax > tempMin) {
        const amplitude = tempMax - tempMin;
        document.getElementById('amplitude_termica').value = amplitude.toFixed(1);
    }
}

function processarArquivoImportacao(input) {
    if (input.files && input.files[0]) {
        const file = input.files[0];
        const preview = document.getElementById('preview-importacao');

        preview.classList.remove('hidden');
        document.getElementById('dados-preview').innerHTML = `
            <p class="text-gray-600">
                <i class="fas fa-file-excel mr-2"></i>
                Arquivo selecionado: ${file.name} (${(file.size / 1024).toFixed(1)} KB)
            </p>
            <p class="text-sm text-gray-500 mt-2">
                Processando arquivo para preview...
            </p>
        `;
    }
}
</script>