<!-- Modal Simples para Nova Leitura -->
<div id="quickLeituraModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-3xl max-h-[90vh] overflow-hidden">
            <form method="POST" action="{{ route('estacoes.storeLeitura', $estacao) }}">
                @csrf

                <!-- Header do Modal -->
                <div class="bg-gradient-to-r from-green-600 to-green-700 px-6 py-4 text-white">
                    <div class="flex justify-between items-center">
                        <div>
                            <h3 class="text-xl font-bold flex items-center">
                                <i class="fas fa-plus-circle mr-3"></i>
                                Nova Leitura - {{ $estacao->nome }}
                            </h3>
                            <p class="text-green-100 text-sm mt-1">
                                {{ ucfirst($estacao->tipo) }} • {{ $estacao->codigo }}
                            </p>
                        </div>
                        <button type="button" onclick="hideQuickLeituraModal()" class="text-white hover:text-gray-200 text-2xl">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>

                <div class="p-6 space-y-6 overflow-y-auto max-h-[70vh]">
                    <!-- Informações Básicas -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-calendar mr-1"></i>
                                Data da Leitura *
                            </label>
                            <input type="date" name="data_leitura" required
                                   value="{{ date('Y-m-d') }}"
                                   max="{{ date('Y-m-d') }}"
                                   class="w-full border-gray-300 rounded-lg shadow-sm focus:border-green-500 focus:ring-green-500">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-clock mr-1"></i>
                                Hora de Registro
                            </label>
                            <input type="time" name="hora_registro" value="{{ date('H:i') }}"
                                   class="w-full border-gray-300 rounded-lg shadow-sm focus:border-green-500 focus:ring-green-500">
                        </div>
                    </div>

                    <!-- Dados Específicos por Tipo de Estação -->
                    @if($estacao->tipo == 'hidrometrica')
                    <div class="bg-blue-50 rounded-lg p-4">
                        <div class="flex justify-between items-center mb-4">
                            <h4 class="font-semibold text-blue-900 flex items-center">
                                <i class="fas fa-water mr-2"></i>
                                Leituras Hidrométricas
                            </h4>
                            @if($estacao->trabalhaComCotas())
                            <div class="flex items-center">
                                <input type="checkbox" id="modo_entrada" class="h-4 w-4 text-blue-600 rounded border-gray-300 focus:ring-blue-500">
                                <label for="modo_entrada" class="ml-2 text-sm text-blue-800">
                                    @if($estacao->recebeCotasManualmente())
                                        Inserir cotas diretamente
                                    @else
                                        Mostrar campos de cotas
                                    @endif
                                </label>
                            </div>
                            @endif
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div class="bg-white rounded p-3 border border-blue-200">
                                <h5 class="font-medium text-blue-800 mb-2">6:00h</h5>
                                <input type="time" name="hora_6h" value="06:00" class="w-full text-sm border-gray-300 rounded mb-2">

                                @if($estacao->recebeCotasManualmente())
                                    <!-- Modo manual: só cotas -->
                                    <input type="number" step="0.001" name="cota_6h" placeholder="Cota (m)"
                                           class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500">
                                    <p class="text-xs text-blue-600 mt-1">Inserir cota diretamente</p>
                                @else
                                    <!-- Modo automático: níveis + cotas opcionais -->
                                    <input type="number" step="0.01" name="nivel_6h" placeholder="Nível (m)"
                                           class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500 nivel-input"
                                           data-periodo="6h">

                                    @if($estacao->trabalhaComCotas())
                                    <div class="cota-fields mt-2" style="display: none;">
                                        <input type="number" step="0.001" name="cota_6h" placeholder="Cota (m)" readonly
                                               class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500 bg-gray-100 cota-calculada">
                                        <p class="text-xs text-green-600 mt-1">Cota calculada automaticamente</p>
                                    </div>
                                    @endif
                                @endif
                            </div>

                            <div class="bg-white rounded p-3 border border-blue-200">
                                <h5 class="font-medium text-blue-800 mb-2">12:00h</h5>
                                <input type="time" name="hora_12h" value="12:00" class="w-full text-sm border-gray-300 rounded mb-2">

                                @if($estacao->recebeCotasManualmente())
                                    <input type="number" step="0.001" name="cota_12h" placeholder="Cota (m)"
                                           class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500">
                                    <p class="text-xs text-blue-600 mt-1">Inserir cota diretamente</p>
                                @else
                                    <input type="number" step="0.01" name="nivel_12h" placeholder="Nível (m)"
                                           class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500 nivel-input"
                                           data-periodo="12h">

                                    @if($estacao->trabalhaComCotas())
                                    <div class="cota-fields mt-2" style="display: none;">
                                        <input type="number" step="0.001" name="cota_12h" placeholder="Cota (m)" readonly
                                               class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500 bg-gray-100 cota-calculada">
                                        <p class="text-xs text-green-600 mt-1">Cota calculada automaticamente</p>
                                    </div>
                                    @endif
                                @endif
                            </div>

                            <div class="bg-white rounded p-3 border border-blue-200">
                                <h5 class="font-medium text-blue-800 mb-2">18:00h</h5>
                                <input type="time" name="hora_18h" value="18:00" class="w-full text-sm border-gray-300 rounded mb-2">

                                @if($estacao->recebeCotasManualmente())
                                    <input type="number" step="0.001" name="cota_18h" placeholder="Cota (m)"
                                           class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500">
                                    <p class="text-xs text-blue-600 mt-1">Inserir cota diretamente</p>
                                @else
                                    <input type="number" step="0.01" name="nivel_18h" placeholder="Nível (m)"
                                           class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500 nivel-input"
                                           data-periodo="18h">

                                    @if($estacao->trabalhaComCotas())
                                    <div class="cota-fields mt-2" style="display: none;">
                                        <input type="number" step="0.001" name="cota_18h" placeholder="Cota (m)" readonly
                                               class="w-full border-gray-300 rounded focus:border-blue-500 focus:ring-blue-500 bg-gray-100 cota-calculada">
                                        <p class="text-xs text-green-600 mt-1">Cota calculada automaticamente</p>
                                    </div>
                                    @endif
                                @endif
                            </div>
                        </div>

                        @if($estacao->trabalhaComCotas() && !$estacao->recebeCotasManualmente())
                        <div class="mt-4 p-3 bg-white rounded border border-blue-200">
                            <h5 class="font-medium text-blue-800 mb-2">Resumo das Cotas</h5>
                            <div class="grid grid-cols-2 gap-4 text-sm">
                                <div>
                                    <strong>Fórmula:</strong>
                                    <span class="font-mono text-blue-600">
                                        @switch($estacao->formula_cota_tipo)
                                            @case('simples')
                                                Cota = Nível + {{ $estacao->cota_referencia ?? '0' }}
                                                @break
                                            @case('linear')
                                                Cota = ({{ $estacao->formula_cota_a ?? '1' }} × Nível) + {{ $estacao->formula_cota_b ?? '0' }}
                                                @break
                                            @case('completa')
                                                Cota = ({{ $estacao->formula_cota_a ?? '0' }} × Nível²) + ({{ $estacao->formula_cota_b ?? '1' }} × Nível) + {{ $estacao->formula_cota_c ?? '0' }}
                                                @break
                                            @case('personalizada')
                                                {{ $estacao->formula_personalizada ?? 'Fórmula personalizada' }}
                                                @break
                                            @default
                                                Cota = Nível + Referência
                                        @endswitch
                                    </span>
                                </div>
                                <div>
                                    <strong>Cota Média:</strong> <span id="cota-media-preview" class="font-mono text-blue-600">-</span>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                    @endif

                    @if(in_array($estacao->tipo, ['pluviometrica', 'meteorologica', 'climatologica']))
                    <div class="bg-green-50 rounded-lg p-4">
                        <h4 class="font-semibold text-green-900 mb-4 flex items-center">
                            <i class="fas fa-cloud-rain mr-2"></i>
                            Dados Pluviométricos
                        </h4>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Precipitação (mm)</label>
                                <input type="number" step="0.1" name="precipitacao_mm" placeholder="Ex: 15.2"
                                       class="w-full border-gray-300 rounded focus:border-green-500 focus:ring-green-500">
                            </div>

                            @if(in_array($estacao->tipo, ['meteorologica', 'climatologica']))
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Temperatura Máxima (°C)</label>
                                <input type="number" step="0.1" name="temperatura_max" placeholder="Ex: 28.5"
                                       class="w-full border-gray-300 rounded focus:border-green-500 focus:ring-green-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Temperatura Mínima (°C)</label>
                                <input type="number" step="0.1" name="temperatura_min" placeholder="Ex: 18.2"
                                       class="w-full border-gray-300 rounded focus:border-green-500 focus:ring-green-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Humidade Relativa (%)</label>
                                <input type="number" step="0.1" min="0" max="100" name="humidade_relativa" placeholder="Ex: 65.5"
                                       class="w-full border-gray-300 rounded focus:border-green-500 focus:ring-green-500">
                            </div>
                            @endif
                        </div>
                    </div>
                    @endif

                    <!-- Observações -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-sticky-note mr-1"></i>
                            Observações
                        </label>
                        <textarea name="observacoes" rows="3"
                                  class="w-full border-gray-300 rounded-lg shadow-sm focus:border-green-500 focus:ring-green-500"
                                  placeholder="Observações sobre as condições, equipamentos, etc..."></textarea>
                    </div>
                </div>

                <!-- Footer do Modal -->
                <div class="bg-gray-50 px-6 py-4 border-t flex justify-between items-center">
                    <div class="flex items-center space-x-4">
                        <a href="{{ route('estacoes.leituras', $estacao) }}" class="text-sm text-blue-600 hover:text-blue-800">
                            <i class="fas fa-chart-line mr-1"></i>
                            Ver todas as leituras
                        </a>
                    </div>

                    <div class="flex space-x-3">
                        <button type="button" onclick="hideQuickLeituraModal()"
                                class="bg-gray-300 hover:bg-gray-400 text-gray-700 px-6 py-2 rounded-lg">
                            <i class="fas fa-times mr-2"></i>
                            Cancelar
                        </button>
                        <button type="submit"
                                class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg">
                            <i class="fas fa-save mr-2"></i>
                            Salvar Leitura
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showQuickLeituraModal() {
    document.getElementById('quickLeituraModal').classList.remove('hidden');
}

function hideQuickLeituraModal() {
    document.getElementById('quickLeituraModal').classList.add('hidden');
}

// Fechar modal ao clicar fora
document.getElementById('quickLeituraModal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        hideQuickLeituraModal();
    }
});

// Configuração da estação para cálculos
window.estacaoConfig = {
    trabalhaComCotas: {{ $estacao->trabalhaComCotas() ? 'true' : 'false' }},
    recebeCotasManualmente: {{ $estacao->recebeCotasManualmente() ? 'true' : 'false' }},
    formulaTipo: '{{ $estacao->formula_cota_tipo ?? "simples" }}',
    cotaReferencia: {{ $estacao->cota_referencia ?? 0 }},
    formulaA: {{ $estacao->formula_cota_a ?? 1 }},
    formulaB: {{ $estacao->formula_cota_b ?? 0 }},
    formulaC: {{ $estacao->formula_cota_c ?? 0 }},
    formulaPersonalizada: '{{ $estacao->formula_personalizada ?? "" }}'
};

document.addEventListener('DOMContentLoaded', function() {
    if (window.estacaoConfig.trabalhaComCotas && !window.estacaoConfig.recebeCotasManualmente) {
        initializeCotaCalculations();
    }
});

function initializeCotaCalculations() {
    // Controle de exibição dos campos de cotas
    const modoEntrada = document.getElementById('modo_entrada');
    const cotaFields = document.querySelectorAll('.cota-fields');

    if (modoEntrada) {
        modoEntrada.addEventListener('change', function() {
            cotaFields.forEach(field => {
                field.style.display = this.checked ? 'block' : 'none';
            });
        });
    }

    // Calculadora de cotas em tempo real
    const nivelInputs = document.querySelectorAll('.nivel-input');

    nivelInputs.forEach(input => {
        input.addEventListener('input', function() {
            calcularCota(this);
            atualizarCotaMedia();
        });
    });

    // Mostrar campos de cotas por padrão se checkbox estiver marcado
    if (modoEntrada && modoEntrada.checked) {
        cotaFields.forEach(field => {
            field.style.display = 'block';
        });
    }
}

function calcularCota(nivelInput) {
    const nivel = parseFloat(nivelInput.value);
    if (isNaN(nivel)) return;

    const periodo = nivelInput.dataset.periodo;
    const cotaInput = document.querySelector(`input[name="cota_${periodo}"]`);

    if (!cotaInput) return;

    let cota = 0;
    const config = window.estacaoConfig;

    switch (config.formulaTipo) {
        case 'simples':
            cota = nivel + config.cotaReferencia;
            break;
        case 'linear':
            cota = (config.formulaA * nivel) + config.formulaB;
            break;
        case 'completa':
            cota = (config.formulaA * nivel * nivel) + (config.formulaB * nivel) + config.formulaC;
            break;
        case 'personalizada':
            cota = calcularFormulaPersonalizada(nivel, config);
            break;
        default:
            cota = nivel + config.cotaReferencia;
    }

    cotaInput.value = cota.toFixed(3);
}

function calcularFormulaPersonalizada(nivel, config) {
    try {
        // Substituir variáveis na fórmula personalizada
        let formula = config.formulaPersonalizada.replace(/[Nn]/g, nivel);
        formula = formula.replace(/[Aa]/g, config.formulaA);
        formula = formula.replace(/[Bb]/g, config.formulaB);
        formula = formula.replace(/[Cc]/g, config.formulaC);

        // Avaliação segura (simplificada - em produção usar biblioteca de parsing)
        return eval(formula);
    } catch (error) {
        console.error('Erro ao calcular fórmula personalizada:', error);
        return nivel + config.cotaReferencia; // Fallback para fórmula simples
    }
}

function atualizarCotaMedia() {
    const cotaInputs = document.querySelectorAll('.cota-calculada');
    const cotas = Array.from(cotaInputs)
        .map(input => parseFloat(input.value))
        .filter(value => !isNaN(value));

    if (cotas.length > 0) {
        const media = cotas.reduce((a, b) => a + b, 0) / cotas.length;
        const previewElement = document.getElementById('cota-media-preview');
        if (previewElement) {
            previewElement.textContent = media.toFixed(3) + 'm';
        }
    }
}
</script>