@extends('layouts.app')

@section('title', 'Configurações de Alertas')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">
                    <i class="fas fa-exclamation-triangle mr-3 text-red-600"></i>
                    Configurações de Alertas
                </h1>
                <p class="text-gray-600 mt-2">Configure o sistema de alertas, escalação e notificações automáticas</p>
            </div>
            <div class="flex items-center space-x-2">
                <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                <span class="text-sm text-green-600">Sistema Ativo</span>
            </div>
        </div>
    </div>

    <!-- Estatísticas -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-red-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Alertas Ativos</p>
                    <p class="text-3xl font-bold text-red-600">{{ $stats['alertas_ativos'] }}</p>
                    <p class="text-xs text-gray-500">Requerem atenção</p>
                </div>
                <div class="bg-red-100 p-3 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-2xl text-red-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-orange-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Alertas Hoje</p>
                    <p class="text-3xl font-bold text-orange-600">{{ $stats['alertas_hoje'] }}</p>
                    <p class="text-xs text-gray-500">Criados hoje</p>
                </div>
                <div class="bg-orange-100 p-3 rounded-lg">
                    <i class="fas fa-calendar text-2xl text-orange-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-purple-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Emergências Mês</p>
                    <p class="text-3xl font-bold text-purple-600">{{ $stats['emergencias_mes'] }}</p>
                    <p class="text-xs text-gray-500">Nível crítico</p>
                </div>
                <div class="bg-purple-100 p-3 rounded-lg">
                    <i class="fas fa-fire text-2xl text-purple-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Tempo Resposta</p>
                    <p class="text-3xl font-bold text-blue-600">{{ $stats['tempo_resposta_medio'] }}</p>
                    <p class="text-xs text-gray-500">Minutos (média)</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-clock text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Configurações de Alertas -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-6">
                <i class="fas fa-cog mr-2 text-red-600"></i>
                Configurações do Sistema de Alertas
            </h3>

            @if ($errors->any())
                <div class="mb-4 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded">
                    <ul class="list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if (session('success'))
                <div class="mb-4 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded">
                    {{ session('success') }}
                </div>
            @endif

            <form method="POST" action="{{ route('configuracoes.alertas.update') }}" class="space-y-4">
                @csrf
                @method('PUT')

                <div class="flex items-center">
                    <input type="checkbox" 
                           id="escalacao_enabled" 
                           name="escalacao_enabled" 
                           value="1" 
                           {{ old('escalacao_enabled', $config['escalacao_enabled']) ? 'checked' : '' }}
                           class="h-4 w-4 text-red-600 focus:ring-red-500 border-gray-300 rounded">
                    <label for="escalacao_enabled" class="ml-2 block text-sm text-gray-900">
                        <strong>Ativar sistema de escalação automática</strong>
                    </label>
                </div>
                <p class="text-xs text-gray-500 ml-6">Se ativado, alertas não resolvidos serão escalados automaticamente</p>

                <div>
                    <label for="tempo_escalacao" class="block text-sm font-medium text-gray-700 mb-1">
                        Tempo para Escalação (minutos) *
                    </label>
                    <input type="number" 
                           id="tempo_escalacao" 
                           name="tempo_escalacao" 
                           value="{{ old('tempo_escalacao', $config['tempo_escalacao']) }}" 
                           min="1" 
                           max="480"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-red-500 focus:border-red-500"
                           required>
                    <p class="text-xs text-gray-500 mt-1">Tempo em minutos antes de escalar o alerta (1-480 minutos)</p>
                </div>

                <div>
                    <label for="horario_relatorio" class="block text-sm font-medium text-gray-700 mb-1">
                        Horário do Relatório Diário *
                    </label>
                    <input type="time" 
                           id="horario_relatorio" 
                           name="horario_relatorio" 
                           value="{{ old('horario_relatorio', $config['horario_relatorio']) }}" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-red-500 focus:border-red-500"
                           required>
                    <p class="text-xs text-gray-500 mt-1">Horário para envio do relatório diário de alertas</p>
                </div>

                <div>
                    <label for="auto_resolve_time" class="block text-sm font-medium text-gray-700 mb-1">
                        Auto-resolução após (horas) *
                    </label>
                    <input type="number" 
                           id="auto_resolve_time" 
                           name="auto_resolve_time" 
                           value="{{ old('auto_resolve_time', $config['auto_resolve_time']) }}" 
                           min="1" 
                           max="168"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-red-500 focus:border-red-500"
                           required>
                    <p class="text-xs text-gray-500 mt-1">Tempo em horas para auto-resolver alertas antigos (1-168 horas)</p>
                </div>

                <div class="pt-4 border-t border-gray-200">
                    <button type="submit" class="w-full bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition-colors flex items-center justify-center">
                        <i class="fas fa-save mr-2"></i>
                        Salvar Configurações
                    </button>
                </div>
            </form>
        </div>

        <!-- Níveis de Alerta e Status -->
        <div class="space-y-6">
            <!-- Status das configurações -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                    Status das Configurações
                </h3>
                
                <div class="space-y-3">
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Escalação:</span>
                        <span class="font-medium text-{{ $config['escalacao_enabled'] ? 'green' : 'red' }}-600">
                            {{ $config['escalacao_enabled'] ? 'Ativa' : 'Inativa' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Tempo Escalação:</span>
                        <span class="font-medium">{{ $config['tempo_escalacao'] }} minutos</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Relatório Diário:</span>
                        <span class="font-medium">{{ $config['horario_relatorio'] }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Auto-resolução:</span>
                        <span class="font-medium">{{ $config['auto_resolve_time'] }} horas</span>
                    </div>
                </div>
            </div>

            <!-- Níveis de Alerta -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-layer-group mr-2 text-orange-600"></i>
                    Níveis de Alerta
                </h3>
                
                <div class="space-y-3">
                    <div class="flex items-center p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                        <div class="flex-shrink-0">
                            <div class="w-3 h-3 bg-yellow-500 rounded-full"></div>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium text-yellow-800">Aviso</p>
                            <p class="text-xs text-yellow-600">Situação que requer atenção</p>
                        </div>
                    </div>

                    <div class="flex items-center p-3 bg-orange-50 border border-orange-200 rounded-lg">
                        <div class="flex-shrink-0">
                            <div class="w-3 h-3 bg-orange-500 rounded-full"></div>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium text-orange-800">Alerta</p>
                            <p class="text-xs text-orange-600">Situação crítica que requer ação</p>
                        </div>
                    </div>

                    <div class="flex items-center p-3 bg-red-50 border border-red-200 rounded-lg">
                        <div class="flex-shrink-0">
                            <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium text-red-800">Emergência</p>
                            <p class="text-xs text-red-600">Situação de emergência imediata</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Fluxo de Escalação -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-6">
            <i class="fas fa-sitemap mr-2 text-purple-600"></i>
            Fluxo de Escalação de Alertas
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Passo 1 -->
            <div class="text-center">
                <div class="bg-blue-100 p-4 rounded-lg mb-3">
                    <i class="fas fa-bell text-2xl text-blue-600"></i>
                </div>
                <h4 class="font-semibold text-gray-900 mb-2">1. Alerta Criado</h4>
                <p class="text-sm text-gray-600">Sistema detecta anomalia e cria alerta automaticamente</p>
            </div>

            <!-- Passo 2 -->
            <div class="text-center">
                <div class="bg-yellow-100 p-4 rounded-lg mb-3">
                    <i class="fas fa-paper-plane text-2xl text-yellow-600"></i>
                </div>
                <h4 class="font-semibold text-gray-900 mb-2">2. Notificação Inicial</h4>
                <p class="text-sm text-gray-600">SMS e email enviados para responsáveis diretos</p>
            </div>

            <!-- Passo 3 -->
            <div class="text-center">
                <div class="bg-orange-100 p-4 rounded-lg mb-3">
                    <i class="fas fa-clock text-2xl text-orange-600"></i>
                </div>
                <h4 class="font-semibold text-gray-900 mb-2">3. Tempo de Espera</h4>
                <p class="text-sm text-gray-600">Aguarda {{ $config['tempo_escalacao'] }} minutos por resolução</p>
            </div>

            <!-- Passo 4 -->
            <div class="text-center">
                <div class="bg-red-100 p-4 rounded-lg mb-3">
                    <i class="fas fa-exclamation-triangle text-2xl text-red-600"></i>
                </div>
                <h4 class="font-semibold text-gray-900 mb-2">4. Escalação</h4>
                <p class="text-sm text-gray-600">Notifica supervisores e gestores seniores</p>
            </div>
        </div>

        <div class="mt-6 p-4 bg-blue-50 border border-blue-200 rounded-md">
            <p class="text-sm text-blue-800">
                <i class="fas fa-info-circle mr-2"></i>
                <strong>Nota:</strong> O sistema de escalação funciona apenas quando ativado nas configurações acima. 
                Alertas resolvidos param automaticamente o processo de escalação.
            </p>
        </div>
    </div>

    <!-- Configurações Avançadas -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-6">
            <i class="fas fa-cogs mr-2 text-gray-600"></i>
            Configurações Avançadas
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-sm font-semibold text-gray-900 mb-3">Tipos de Alertas Monitorizados:</h4>
                <ul class="text-sm text-gray-600 space-y-2">
                    <li class="flex items-center">
                        <i class="fas fa-water text-blue-500 mr-2"></i>
                        Níveis críticos de água em barragens
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-thermometer-half text-red-500 mr-2"></i>
                        Temperaturas extremas
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-tint text-cyan-500 mr-2"></i>
                        Qualidade da água comprometida
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-exclamation-triangle text-yellow-500 mr-2"></i>
                        Falhas em equipamentos
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-wifi text-gray-500 mr-2"></i>
                        Perda de comunicação com estações
                    </li>
                </ul>
            </div>
            
            <div>
                <h4 class="text-sm font-semibold text-gray-900 mb-3">Destinatários de Escalação:</h4>
                <ul class="text-sm text-gray-600 space-y-2">
                    <li class="flex items-center">
                        <i class="fas fa-user text-green-500 mr-2"></i>
                        Operadores de turno (1º nível)
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-user-tie text-blue-500 mr-2"></i>
                        Supervisores (2º nível)
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-user-shield text-purple-500 mr-2"></i>
                        Gestores (3º nível)
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-users text-red-500 mr-2"></i>
                        Equipa de emergência (crítico)
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Ações Rápidas -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-bolt mr-2 text-yellow-600"></i>
            Ações Rápidas
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <a href="{{ route('alertas.index') }}" class="flex items-center justify-center p-4 border border-red-300 bg-red-50 text-red-700 rounded-lg hover:bg-red-100 transition-colors">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                Ver Alertas Ativos
            </a>
            
            <a href="{{ route('notifications.dashboard') }}" class="flex items-center justify-center p-4 border border-purple-300 bg-purple-50 text-purple-700 rounded-lg hover:bg-purple-100 transition-colors">
                <i class="fas fa-chart-bar mr-2"></i>
                Dashboard Notificações
            </a>
            
            <a href="{{ route('notifications.historico') }}" class="flex items-center justify-center p-4 border border-blue-300 bg-blue-50 text-blue-700 rounded-lg hover:bg-blue-100 transition-colors">
                <i class="fas fa-history mr-2"></i>
                Histórico Alertas
            </a>
            
            <a href="{{ route('configuracoes.index') }}" class="flex items-center justify-center p-4 border border-gray-300 bg-gray-50 text-gray-700 rounded-lg hover:bg-gray-100 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar às Configurações
            </a>
        </div>
    </div>
</div>
@endsection