@extends('layouts.app')

@section('title', 'Informações do Sistema')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">
                    <i class="fas fa-info-circle mr-3 text-indigo-600"></i>
                    Informações do Sistema
                </h1>
                <p class="text-gray-600 mt-2">Detalhes técnicos e versões do sistema hidrológico</p>
            </div>
            <div class="flex items-center space-x-2">
                <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                <span class="text-sm text-green-600">Sistema operacional</span>
            </div>
        </div>
    </div>

    <!-- Navegação -->
    <div class="flex space-x-4">
        <a href="{{ route('configuracoes.index') }}"
           class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors flex items-center">
            <i class="fas fa-arrow-left mr-2"></i>
            Voltar às Configurações
        </a>
    </div>

    <!-- Informações do Sistema -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

        <!-- Software -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                <i class="fas fa-code mr-2 text-blue-600"></i>
                Software
            </h3>

            <div class="space-y-3">
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Versão PHP:</span>
                    <span class="font-medium">{{ $info['php_version'] }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Versão Laravel:</span>
                    <span class="font-medium">{{ $info['laravel_version'] }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Servidor Web:</span>
                    <span class="font-medium">{{ $info['server_software'] }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Ambiente:</span>
                    <span class="font-medium">
                        <span class="px-2 py-1 text-xs rounded-full
                            {{ $info['environment'] === 'production' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                            {{ ucfirst($info['environment']) }}
                        </span>
                    </span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Modo Debug:</span>
                    <span class="font-medium">
                        <span class="px-2 py-1 text-xs rounded-full
                            {{ $info['debug_mode'] === 'Desativado' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ $info['debug_mode'] }}
                        </span>
                    </span>
                </div>
            </div>
        </div>

        <!-- Configurações -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                <i class="fas fa-cogs mr-2 text-green-600"></i>
                Configurações
            </h3>

            <div class="space-y-3">
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Timezone:</span>
                    <span class="font-medium">{{ $info['timezone'] }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Localização:</span>
                    <span class="font-medium">{{ $info['locale'] }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Driver Cache:</span>
                    <span class="font-medium">{{ ucfirst($info['cache_driver']) }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Driver Queue:</span>
                    <span class="font-medium">{{ ucfirst($info['queue_driver']) }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Disco de Storage:</span>
                    <span class="font-medium">{{ ucfirst($info['storage_disk']) }}</span>
                </div>
            </div>
        </div>

        <!-- Base de Dados -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                <i class="fas fa-database mr-2 text-purple-600"></i>
                Base de Dados
            </h3>

            <div class="space-y-3">
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Tipo de BD:</span>
                    <span class="font-medium">{{ ucfirst($info['database']) }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Status Conexão:</span>
                    <span class="font-medium">
                        <span class="px-2 py-1 text-xs bg-green-100 text-green-800 rounded-full">
                            Conectada
                        </span>
                    </span>
                </div>
            </div>
        </div>

        <!-- Sistema -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                <i class="fas fa-server mr-2 text-orange-600"></i>
                Sistema Operativo
            </h3>

            <div class="space-y-3">
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Sistema:</span>
                    <span class="font-medium">{{ PHP_OS }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Arquitetura:</span>
                    <span class="font-medium">{{ php_uname('m') }}</span>
                </div>
                <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Hostname:</span>
                    <span class="font-medium">{{ php_uname('n') }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Memória PHP:</span>
                    <span class="font-medium">{{ ini_get('memory_limit') }}</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Extensões PHP -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
            <i class="fas fa-puzzle-piece mr-2 text-red-600"></i>
            Extensões PHP Importantes
        </h3>

        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
            @php
                $extensions = ['pdo', 'curl', 'gd', 'mbstring', 'xml', 'zip', 'openssl', 'json', 'bcmath', 'fileinfo'];
            @endphp

            @foreach($extensions as $ext)
                <div class="flex items-center space-x-2">
                    @if(extension_loaded($ext))
                        <i class="fas fa-check text-green-600"></i>
                        <span class="text-sm text-green-700">{{ $ext }}</span>
                    @else
                        <i class="fas fa-times text-red-600"></i>
                        <span class="text-sm text-red-700">{{ $ext }}</span>
                    @endif
                </div>
            @endforeach
        </div>
    </div>

    <!-- Ações -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
            <i class="fas fa-tools mr-2 text-yellow-600"></i>
            Ações de Sistema
        </h3>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <button onclick="window.print()"
                    class="flex items-center justify-center p-4 border border-blue-300 bg-blue-50 text-blue-700 rounded-lg hover:bg-blue-100 transition-colors">
                <i class="fas fa-print mr-2"></i>
                Imprimir Informações
            </button>

            <a href="{{ route('configuracoes.sistema') }}"
               class="flex items-center justify-center p-4 border border-green-300 bg-green-50 text-green-700 rounded-lg hover:bg-green-100 transition-colors">
                <i class="fas fa-cogs mr-2"></i>
                Configurar Sistema
            </a>

            <button onclick="location.reload()"
                    class="flex items-center justify-center p-4 border border-gray-300 bg-gray-50 text-gray-700 rounded-lg hover:bg-gray-100 transition-colors">
                <i class="fas fa-sync-alt mr-2"></i>
                Atualizar Informações
            </button>
        </div>
    </div>
</div>
@endsection