@extends('layouts.app')

@section('title', 'Configurações SMS/Twilio')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">
                    <i class="fas fa-sms mr-3 text-green-600"></i>
                    Configurações SMS/Twilio
                </h1>
                <p class="text-gray-600 mt-2">Configure as credenciais e parâmetros do serviço Twilio para envio de SMS</p>
            </div>
            <div class="flex items-center space-x-2">
                @if($config['sid'])
                    <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                    <span class="text-sm text-green-600">Configurado</span>
                @else
                    <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                    <span class="text-sm text-red-600">Não configurado</span>
                @endif
            </div>
        </div>
    </div>

    <!-- Estatísticas -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">SMS Hoje</p>
                    <p class="text-3xl font-bold text-green-600">{{ $stats['sms_enviados_hoje'] }}</p>
                    <p class="text-xs text-gray-500">Enviados hoje</p>
                </div>
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-paper-plane text-2xl text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">SMS Mês</p>
                    <p class="text-3xl font-bold text-blue-600">{{ $stats['sms_enviados_mes'] }}</p>
                    <p class="text-xs text-gray-500">Enviados este mês</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-calendar text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-purple-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Taxa Entrega</p>
                    <p class="text-3xl font-bold text-purple-600">{{ $stats['taxa_entrega'] }}%</p>
                    <p class="text-xs text-gray-500">Taxa de sucesso</p>
                </div>
                <div class="bg-purple-100 p-3 rounded-lg">
                    <i class="fas fa-check-circle text-2xl text-purple-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-orange-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Usuários SMS</p>
                    <p class="text-3xl font-bold text-orange-600">{{ $stats['usuarios_com_sms'] }}</p>
                    <p class="text-xs text-gray-500">Com SMS ativado</p>
                </div>
                <div class="bg-orange-100 p-3 rounded-lg">
                    <i class="fas fa-users text-2xl text-orange-600"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Configurações Twilio -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-6">
                <i class="fas fa-cog mr-2 text-green-600"></i>
                Credenciais Twilio
            </h3>

            @if ($errors->any())
                <div class="mb-4 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded">
                    <ul class="list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if (session('success'))
                <div class="mb-4 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded">
                    {{ session('success') }}
                </div>
            @endif

            <form method="POST" action="{{ route('configuracoes.sms.update') }}" class="space-y-4">
                @csrf
                @method('PUT')

                <div>
                    <label for="twilio_sid" class="block text-sm font-medium text-gray-700 mb-1">
                        Account SID *
                    </label>
                    <input type="text" 
                           id="twilio_sid" 
                           name="twilio_sid" 
                           value="{{ old('twilio_sid', $config['sid']) }}" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-green-500 focus:border-green-500"
                           placeholder="AC..." 
                           required>
                    <p class="text-xs text-gray-500 mt-1">Encontre no console Twilio</p>
                </div>

                <div>
                    <label for="twilio_auth_token" class="block text-sm font-medium text-gray-700 mb-1">
                        Auth Token *
                    </label>
                    <input type="password" 
                           id="twilio_auth_token" 
                           name="twilio_auth_token" 
                           value="{{ old('twilio_auth_token', $config['auth_token']) }}" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-green-500 focus:border-green-500"
                           placeholder="Token de autenticação" 
                           required>
                    <p class="text-xs text-gray-500 mt-1">Token secreto do Twilio</p>
                </div>

                <div>
                    <label for="twilio_phone_number" class="block text-sm font-medium text-gray-700 mb-1">
                        Número Twilio *
                    </label>
                    <input type="text" 
                           id="twilio_phone_number" 
                           name="twilio_phone_number" 
                           value="{{ old('twilio_phone_number', $config['phone_number']) }}" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-green-500 focus:border-green-500"
                           placeholder="+1234567890" 
                           required>
                    <p class="text-xs text-gray-500 mt-1">Número verificado no Twilio (formato internacional)</p>
                </div>

                <div class="flex items-center">
                    <input type="checkbox" 
                           id="sms_enabled" 
                           name="sms_enabled" 
                           value="1" 
                           {{ old('sms_enabled', $config['sms_enabled']) ? 'checked' : '' }}
                           class="h-4 w-4 text-green-600 focus:ring-green-500 border-gray-300 rounded">
                    <label for="sms_enabled" class="ml-2 block text-sm text-gray-900">
                        Ativar envio de SMS
                    </label>
                </div>

                <div class="pt-4 border-t border-gray-200">
                    <button type="submit" class="w-full bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors flex items-center justify-center">
                        <i class="fas fa-save mr-2"></i>
                        Salvar Configurações
                    </button>
                </div>
            </form>
        </div>

        <!-- Teste de SMS -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-6">
                <i class="fas fa-test-tube mr-2 text-blue-600"></i>
                Teste de SMS
            </h3>

            <div class="mb-4 bg-blue-50 border border-blue-200 text-blue-700 px-4 py-3 rounded">
                <p class="text-sm">
                    <i class="fas fa-info-circle mr-2"></i>
                    Use esta função para testar se o SMS está funcionando corretamente.
                </p>
            </div>

            <form method="POST" action="{{ route('configuracoes.sms.test') }}" class="space-y-4">
                @csrf

                <div>
                    <label for="telefone_teste" class="block text-sm font-medium text-gray-700 mb-1">
                        Número para Teste *
                    </label>
                    <input type="text" 
                           id="telefone_teste" 
                           name="telefone_teste" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                           placeholder="+258841234567" 
                           required>
                    <p class="text-xs text-gray-500 mt-1">Número de telefone em formato internacional</p>
                </div>

                <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors flex items-center justify-center">
                    <i class="fas fa-paper-plane mr-2"></i>
                    Enviar SMS de Teste
                </button>
            </form>

            <!-- Status das configurações -->
            <div class="mt-6 space-y-2">
                <h4 class="text-sm font-medium text-gray-900">Status das Configurações:</h4>
                <div class="space-y-1">
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Account SID:</span>
                        <span class="font-medium text-{{ $config['sid'] ? 'green' : 'red' }}-600">
                            {{ $config['sid'] ? 'Configurado' : 'Não configurado' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Auth Token:</span>
                        <span class="font-medium text-{{ $config['auth_token'] ? 'green' : 'red' }}-600">
                            {{ $config['auth_token'] ? 'Configurado' : 'Não configurado' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Número Twilio:</span>
                        <span class="font-medium">{{ $config['phone_number'] ?: 'N/A' }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">SMS Ativo:</span>
                        <span class="font-medium text-{{ $config['sms_enabled'] ? 'green' : 'red' }}-600">
                            {{ $config['sms_enabled'] ? 'Sim' : 'Não' }}
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Informações Adicionais -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-info-circle mr-2 text-blue-600"></i>
            Informações Importantes
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-sm font-semibold text-gray-900 mb-2">Como configurar:</h4>
                <ol class="text-sm text-gray-600 space-y-1 list-decimal list-inside">
                    <li>Crie uma conta no <a href="https://www.twilio.com" target="_blank" class="text-blue-600 hover:underline">Twilio.com</a></li>
                    <li>Acesse o console e obtenha o Account SID e Auth Token</li>
                    <li>Compre um número de telefone no Twilio</li>
                    <li>Configure as credenciais acima</li>
                    <li>Teste o envio de SMS</li>
                </ol>
            </div>
            
            <div>
                <h4 class="text-sm font-semibold text-gray-900 mb-2">Formato dos números:</h4>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li><strong>Moçambique:</strong> +258841234567</li>
                    <li><strong>África do Sul:</strong> +27821234567</li>
                    <li><strong>Brasil:</strong> +5511987654321</li>
                    <li><strong>Portugal:</strong> +351910123456</li>
                </ul>
                
                <div class="mt-4 p-3 bg-yellow-50 border border-yellow-200 rounded-md">
                    <p class="text-xs text-yellow-800">
                        <i class="fas fa-exclamation-triangle mr-1"></i>
                        <strong>Atenção:</strong> Verifique os custos de SMS no Twilio para os países de destino.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Ações Rápidas -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-bolt mr-2 text-yellow-600"></i>
            Ações Rápidas
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="{{ route('notifications.historico') }}" class="flex items-center justify-center p-4 border border-blue-300 bg-blue-50 text-blue-700 rounded-lg hover:bg-blue-100 transition-colors">
                <i class="fas fa-history mr-2"></i>
                Histórico SMS
            </a>
            
            <a href="{{ route('notifications.dashboard') }}" class="flex items-center justify-center p-4 border border-purple-300 bg-purple-50 text-purple-700 rounded-lg hover:bg-purple-100 transition-colors">
                <i class="fas fa-chart-bar mr-2"></i>
                Dashboard Notificações
            </a>
            
            <a href="{{ route('configuracoes.index') }}" class="flex items-center justify-center p-4 border border-gray-300 bg-gray-50 text-gray-700 rounded-lg hover:bg-gray-100 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar às Configurações
            </a>
        </div>
    </div>
</div>
@endsection