@extends('layouts.app')

@section('title', 'Contexto Hidrológico - Filtros e Análise')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-filter mr-3 text-blue-600"></i>
                    Contexto Hidrológico
                </h1>
                <p class="text-gray-600 mt-2">Filtrar e analisar informações do sistema hidrológico por divisão administrativa, área de jurisdição ou bacia</p>
            </div>
            <div class="flex space-x-2">
                <a href="{{ route('contexto.exportar', request()->query()) }}" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                    <i class="fas fa-download mr-2"></i>
                    Exportar Dados
                </a>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">
            <i class="fas fa-sliders-h mr-2 text-blue-600"></i>
            Filtros de Pesquisa
        </h3>

        <form method="GET" action="{{ route('contexto.index') }}" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <!-- Tipo de Divisão -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Tipo de Divisão Administrativa</label>
                <select name="tipo_divisao" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                    <option value="">Todos os tipos</option>
                    <option value="provincia" {{ $filtros['tipo_divisao'] == 'provincia' ? 'selected' : '' }}>Província</option>
                    <option value="distrito" {{ $filtros['tipo_divisao'] == 'distrito' ? 'selected' : '' }}>Distrito</option>
                    <option value="municipio" {{ $filtros['tipo_divisao'] == 'municipio' ? 'selected' : '' }}>Município</option>
                    <option value="setor" {{ $filtros['tipo_divisao'] == 'setor' ? 'selected' : '' }}>Setor</option>
                    <option value="zona" {{ $filtros['tipo_divisao'] == 'zona' ? 'selected' : '' }}>Zona</option>
                </select>
            </div>

            <!-- Divisão Administrativa Específica -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Divisão Administrativa</label>
                <select name="divisao_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                    <option value="">Todas as divisões</option>
                    @foreach($divisoes as $tipo => $divisoesTipo)
                        <optgroup label="{{ ucfirst($tipo) }}">
                            @foreach($divisoesTipo as $divisao)
                                <option value="{{ $divisao->id }}" {{ $filtros['divisao_id'] == $divisao->id ? 'selected' : '' }}>
                                    {{ $divisao->nome }}
                                </option>
                            @endforeach
                        </optgroup>
                    @endforeach
                </select>
            </div>

            <!-- Área de Jurisdição -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Área de Jurisdição</label>
                <select name="area_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                    <option value="">Todas as áreas</option>
                    @foreach($areas as $area)
                        <option value="{{ $area->id }}" {{ $filtros['area_id'] == $area->id ? 'selected' : '' }}>
                            {{ $area->nome }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Bacia Hidrográfica -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Bacia Hidrográfica</label>
                <select name="bacia_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                    <option value="">Todas as bacias</option>
                    @foreach($bacias as $bacia)
                        <option value="{{ $bacia->id }}" {{ $filtros['bacia_id'] == $bacia->id ? 'selected' : '' }}>
                            {{ $bacia->nome }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Data Início -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ $filtros['data_inicio'] }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
            </div>

            <!-- Data Fim -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                <input type="date" name="data_fim" value="{{ $filtros['data_fim'] }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
            </div>

            <!-- Botões -->
            <div class="md:col-span-3 flex justify-end space-x-2">
                <a href="{{ route('contexto.index') }}" class="bg-gray-500 text-white px-6 py-2 rounded-md hover:bg-gray-600 transition-colors">
                    <i class="fas fa-redo mr-2"></i>
                    Limpar Filtros
                </a>
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-search mr-2"></i>
                    Aplicar Filtros
                </button>
            </div>
        </form>
    </div>

    <!-- Estatísticas do Contexto -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-purple-100 rounded-full p-3">
                    <i class="fas fa-map text-2xl text-purple-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Bacias</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $contexto['stats']['total_bacias'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-green-100 rounded-full p-3">
                    <i class="fas fa-satellite-dish text-2xl text-green-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Estações</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $contexto['stats']['total_estacoes'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-blue-100 rounded-full p-3">
                    <i class="fas fa-water text-2xl text-blue-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Barragens</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $contexto['stats']['total_barragens'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-yellow-100 rounded-full p-3">
                    <i class="fas fa-chart-area text-2xl text-yellow-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Área Total (km²)</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($contexto['stats']['area_total_km2'], 2) }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Resultados: Bacias -->
    @if($contexto['bacias']->count() > 0)
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-map mr-2 text-purple-600"></i>
                Bacias Hidrográficas ({{ $contexto['bacias']->count() }})
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-800 text-white">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Nome</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Código</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Divisão Administrativa</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Área (km²)</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($contexto['bacias'] as $bacia)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $bacia->nome }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $bacia->codigo }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $bacia->divisaoAdministrativa?->nome ?? '-' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">{{ number_format($bacia->area_km2, 2) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                            <a href="{{ route('bacias.show', $bacia) }}" class="text-blue-600 hover:text-blue-800">
                                Ver Detalhes
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif

    <!-- Resultados: Estações -->
    @if($contexto['estacoes']->count() > 0)
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-satellite-dish mr-2 text-green-600"></i>
                Estações ({{ $contexto['estacoes']->count() }})
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-800 text-white">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Nome</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Código</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Tipo</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Bacia</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Estado</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($contexto['estacoes'] as $estacao)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $estacao->nome }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $estacao->codigo }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ ucfirst($estacao->tipo) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $estacao->bacia_hidrografica?->nome ?? '-' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                            <span class="px-2 py-1 rounded-full text-xs {{ $estacao->estado == 'activa' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                {{ ucfirst($estacao->estado) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                            <a href="{{ route('estacoes.show', $estacao) }}" class="text-blue-600 hover:text-blue-800">
                                Ver Detalhes
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif

    <!-- Resultados: Barragens -->
    @if($contexto['barragens']->count() > 0)
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-water mr-2 text-blue-600"></i>
                Barragens ({{ $contexto['barragens']->count() }})
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-800 text-white">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Nome</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Código</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Bacia</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Província</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Estado</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($contexto['barragens'] as $barragem)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $barragem->nome }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $barragem->codigo }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $barragem->bacia_hidrografica?->nome ?? '-' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">{{ $barragem->provincia ?? '-' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                            <span class="px-2 py-1 rounded-full text-xs {{ $barragem->estado == 'activa' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                {{ ucfirst($barragem->estado) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                            <a href="{{ route('barragens.show', $barragem) }}" class="text-blue-600 hover:text-blue-800">
                                Ver Detalhes
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif
</div>
@endsection
