@extends('layouts.app')

@section('title', 'Leituras - ' . $estacao->nome)

@push('styles')
<link rel="stylesheet" href="{{ asset('css/leituras.css') }}">
@endpush

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow">
        <!-- Breadcrumb -->
        <div class="px-6 py-3 border-b border-gray-200 bg-gray-50">
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-2 md:space-x-4">
                    <li class="inline-flex items-center">
                        <a href="{{ route('dashboard') }}" class="text-gray-500 hover:text-gray-700">
                            <i class="fas fa-home mr-2"></i>
                            Dashboard
                        </a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('estacoes.index') }}" class="text-gray-500 hover:text-gray-700">Estações</a>
                        </div>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('estacoes.show', $estacao) }}" class="text-gray-500 hover:text-gray-700">{{ $estacao->nome }}</a>
                        </div>
                    </li>
                    <li aria-current="page">
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <span class="text-gray-800 font-medium">Leituras</span>
                        </div>
                    </li>
                </ol>
            </nav>
        </div>

        <!-- Header Principal -->
        <div class="px-6 py-6">
            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                <div class="flex-1">
                    <div class="flex items-center mb-2">
                        <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-chart-line text-white text-xl"></i>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900">Leituras da Estação</h1>
                            <p class="text-gray-600">{{ $estacao->nome }} • Código: {{ $estacao->codigo }}</p>
                        </div>
                    </div>

                    <div class="flex flex-wrap items-center gap-4 mt-4">
                        <div class="flex items-center bg-blue-50 px-3 py-1 rounded-full">
                            <i class="fas fa-satellite-dish text-blue-600 mr-2"></i>
                            <span class="text-sm font-medium text-blue-800">{{ ucfirst($estacao->tipo) }}</span>
                        </div>

                        <div class="flex items-center bg-green-50 px-3 py-1 rounded-full">
                            <i class="fas fa-map-marker-alt text-green-600 mr-2"></i>
                            <span class="text-sm font-medium text-green-800">{{ $estacao->provincia ?? 'N/A' }}</span>
                        </div>

                        <div class="flex items-center
                            @if($estacao->estado == 'activa') bg-green-50
                            @elseif($estacao->estado == 'inactiva') bg-red-50
                            @else bg-yellow-50 @endif px-3 py-1 rounded-full">
                            <i class="fas fa-circle
                                @if($estacao->estado == 'activa') text-green-600
                                @elseif($estacao->estado == 'inactiva') text-red-600
                                @else text-yellow-600 @endif mr-2"></i>
                            <span class="text-sm font-medium
                                @if($estacao->estado == 'activa') text-green-800
                                @elseif($estacao->estado == 'inactiva') text-red-800
                                @else text-yellow-800 @endif">{{ ucfirst($estacao->estado) }}</span>
                        </div>
                    </div>
                </div>

                <div class="flex flex-wrap gap-3 mt-4 lg:mt-0">
                    <a href="{{ route('estacoes.leituras.grid', $estacao) }}"
                       class="bg-purple-600 hover:bg-purple-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center">
                        <i class="fas fa-th mr-2"></i>
                        Modo Grid
                    </a>

                    <a href="{{ route('estacoes.leituras.create', $estacao) }}"
                       class="bg-green-600 hover:bg-green-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center">
                        <i class="fas fa-plus mr-2"></i>
                        Nova Leitura
                    </a>

                    <a href="{{ route('estacoes.leituras.import', $estacao) }}"
                       class="bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center">
                        <i class="fas fa-file-import mr-2"></i>
                        Importar
                    </a>

                    <a href="{{ route('estacoes.exportar-leituras', $estacao) }}"
                       class="bg-purple-600 hover:bg-purple-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center">
                        <i class="fas fa-download mr-2"></i>
                        Exportar
                    </a>

                    <a href="{{ route('estacoes.show', $estacao) }}"
                       class="bg-gray-600 hover:bg-gray-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Voltar
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros e Pesquisa -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ request('data_inicio') }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-green-500 focus:ring-green-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                <input type="date" name="data_fim" value="{{ request('data_fim') }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-green-500 focus:ring-green-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Operador</label>
                <select name="operador" class="w-full border-gray-300 rounded-md shadow-sm focus:border-green-500 focus:ring-green-500">
                    <option value="">Todos</option>
                    @foreach($leituras->pluck('operador.name')->unique()->filter() as $operador)
                        <option value="{{ $operador }}" {{ request('operador') == $operador ? 'selected' : '' }}>
                            {{ $operador }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="flex items-end">
                <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                    <i class="fas fa-search mr-2"></i>
                    Filtrar
                </button>
            </div>
        </form>
    </div>

    <!-- Tabela de Leituras -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-medium text-gray-900">
                    <i class="fas fa-table mr-2 text-green-600"></i>
                    Histórico de Leituras
                </h3>
                <span class="text-sm text-gray-600">
                    Total: {{ $leituras->total() }} registros
                </span>
            </div>
        </div>

        @if($leituras->count() > 0)
        <div class="overflow-x-auto">
            <table class="w-full table-fixed divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Data</th>

                        @if($estacao->tipo == 'hidrometrica')
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nível 6h</th>
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nível 12h</th>
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nível 18h</th>

                            @if($estacao->trabalhaComCotas())
                                <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Cota 6h</th>
                                <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Cota 12h</th>
                                <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Cota 18h</th>
                            @endif
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Caudal</th>
                        @endif

                        @if(in_array($estacao->tipo, ['pluviometrica', 'meteorologica', 'climatologica']))
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Precipitação</th>
                        @endif

                        @if(in_array($estacao->tipo, ['meteorologica', 'climatologica']))
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Temp. Max</th>
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Temp. Min</th>
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Humidade</th>
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Vento</th>
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pressão</th>
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Radiação</th>
                            <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Evaporação</th>
                        @endif

                        <th class="w-1/8 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Operador</th>
                        <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Observações</th>
                        <th class="w-1/8 px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($leituras as $leitura)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900">
                                {{ $leitura->data_leitura->format('d/m/Y') }}
                            </div>
                            <div class="text-xs text-gray-500">
                                {{ $leitura->created_at->format('H:i') }}
                            </div>
                        </td>

                        @if($estacao->tipo == 'hidrometrica')
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->nivel_6h ?? 'N/A' }}{{ $leitura->nivel_6h ? 'm' : '' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->nivel_12h ?? 'N/A' }}{{ $leitura->nivel_12h ? 'm' : '' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->nivel_18h ?? 'N/A' }}{{ $leitura->nivel_18h ? 'm' : '' }}
                            </td>

                            @if($estacao->trabalhaComCotas())
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if($leitura->cota_6h)
                                        <span class="text-green-700 font-medium">{{ number_format($leitura->cota_6h, 3) }}m</span>
                                    @else
                                        <span class="text-gray-400">N/A</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if($leitura->cota_12h)
                                        <span class="text-green-700 font-medium">{{ number_format($leitura->cota_12h, 3) }}m</span>
                                    @else
                                        <span class="text-gray-400">N/A</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if($leitura->cota_18h)
                                        <span class="text-green-700 font-medium">{{ number_format($leitura->cota_18h, 3) }}m</span>
                                    @else
                                        <span class="text-gray-400">N/A</span>
                                    @endif
                                </td>
                            @endif
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->caudal ?? 'N/A' }}{{ $leitura->caudal ? ' m³/s' : '' }}
                            </td>
                        @endif

                        @if(in_array($estacao->tipo, ['pluviometrica', 'meteorologica', 'climatologica']))
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->precipitacao_mm ?? 'N/A' }}{{ $leitura->precipitacao_mm ? 'mm' : '' }}
                            </td>
                        @endif

                        @if(in_array($estacao->tipo, ['meteorologica', 'climatologica']))
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->temperatura_max ?? 'N/A' }}{{ $leitura->temperatura_max ? '°C' : '' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->temperatura_min ?? 'N/A' }}{{ $leitura->temperatura_min ? '°C' : '' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->humidade_relativa ?? 'N/A' }}{{ $leitura->humidade_relativa ? '%' : '' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->velocidade_vento ?? 'N/A' }}{{ $leitura->velocidade_vento ? ' m/s' : '' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->pressao_atmosferica ?? 'N/A' }}{{ $leitura->pressao_atmosferica ? ' hPa' : '' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->radiacao_solar ?? 'N/A' }}{{ $leitura->radiacao_solar ? ' W/m²' : '' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $leitura->evaporacao ?? 'N/A' }}{{ $leitura->evaporacao ? ' mm' : '' }}
                            </td>
                        @endif

                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                            {{ $leitura->operador->name ?? 'N/A' }}
                        </td>

                        <td class="px-6 py-4 text-sm text-gray-500 max-w-xs truncate">
                            {{ $leitura->observacoes ?? '-' }}
                        </td>

                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <div class="flex justify-center space-x-2">
                                <!-- Editar -->
                                <a href="#"
                                   class="bg-green-500 hover:bg-green-600 text-white px-3 py-1 rounded text-xs font-medium"
                                   title="Editar leitura"
                                   onclick="alert('Função em desenvolvimento'); return false;">
                                    <i class="fas fa-edit"></i>
                                </a>

                                <!-- Duplicar -->
                                <button onclick="duplicarLeitura({{ $leitura->id }})"
                                        class="bg-yellow-500 hover:bg-yellow-600 text-white px-3 py-1 rounded text-xs font-medium"
                                        title="Duplicar leitura">
                                    <i class="fas fa-copy"></i>
                                </button>

                                <!-- Excluir -->
                                <button onclick="excluirLeitura({{ $leitura->id }})"
                                        class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded text-xs font-medium"
                                        title="Excluir leitura">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Paginação -->
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
            {{ $leituras->links() }}
        </div>
        @else
        <div class="text-center py-12">
            <i class="fas fa-chart-line text-4xl text-gray-400 mb-4"></i>
            <h3 class="text-lg font-medium text-gray-900 mb-2">Nenhuma leitura encontrada</h3>
            <p class="text-gray-500 mb-6">Ainda não há leituras registradas para esta estação.</p>
            <a href="{{ route('estacoes.leituras.create', $estacao) }}"
               class="bg-green-600 hover:bg-green-700 text-white font-bold px-8 py-4 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 inline-flex items-center">
                <i class="fas fa-plus mr-3"></i>
                Nova Leitura
            </a>
        </div>
        @endif
    </div>
</div>


<!-- Scripts necessários -->
<script>
// Configurar variáveis globais para o JavaScript
window.estacaoId = {{ $estacao->id }};
window.estacaoTipo = '{{ $estacao->tipo }}';
window.estacaoCodigo = '{{ $estacao->codigo }}';
window.estacaoNome = '{{ $estacao->nome }}';
window.estacaoNivelAlerta = {{ $estacao->nivel_alerta ?? 'null' }};

// Verificar se deve redirecionar para nova leitura
document.addEventListener('DOMContentLoaded', function() {
    // Se URL contém #nova-leitura, redirecionar para página de nova leitura
    if (window.location.hash === '#nova-leitura') {
        window.location.href = "{{ route('estacoes.leituras.create', $estacao) }}";
    }
});

// Funções para ações da tabela
function verDetalhesLeitura(leituraId) {
    alert('Funcionalidade em desenvolvimento');
}

function duplicarLeitura(leituraId) {
    if (confirm('Deseja criar uma nova leitura baseada nesta?')) {
        window.location.href = `{{ route('estacoes.leituras.create', $estacao) }}?duplicate=${leituraId}`;
    }
}

function excluirLeitura(leituraId) {
    if (confirm('Tem certeza que deseja excluir esta leitura? Esta ação não pode ser desfeita.')) {
        // Criar formulário para DELETE
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/estacoes/{{ $estacao->id }}/leituras/${leituraId}`;

        // Token CSRF
        const csrfInput = document.createElement('input');
        csrfInput.type = 'hidden';
        csrfInput.name = '_token';
        csrfInput.value = '{{ csrf_token() }}';
        form.appendChild(csrfInput);

        // Method DELETE
        const methodInput = document.createElement('input');
        methodInput.type = 'hidden';
        methodInput.name = '_method';
        methodInput.value = 'DELETE';
        form.appendChild(methodInput);

        document.body.appendChild(form);
        form.submit();
    }
}
</script>
@endsection