@extends('app')

@section('title', 'Estatísticas')

@section('content')
<div class="p-6 space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <h1 class="text-3xl font-bold text-gray-900">
            <i class="fas fa-chart-bar text-blue-600 mr-3"></i>
            Estatísticas - Médias Aritméticas
        </h1>
        <p class="text-gray-600 mt-2">
            Análise estatística com gráficos de precipitação, cotas e níveis hidrométricos
        </p>
    </div>

    <!-- Tabs de Tipo -->
    <div class="bg-white rounded-lg shadow">
        <div class="border-b border-gray-200">
            <nav class="flex -mb-px">
                <a href="?tipo=precipitacao" class="tab-button {{ $tipo === 'precipitacao' ? 'active border-blue-500 text-blue-600' : 'border-transparent text-gray-500' }} px-6 py-4 text-sm font-medium border-b-2 hover:text-gray-700 hover:border-gray-300">
                    <i class="fas fa-cloud-rain mr-2"></i>
                    Precipitação
                </a>
                <a href="?tipo=cotas" class="tab-button {{ $tipo === 'cotas' ? 'active border-blue-500 text-blue-600' : 'border-transparent text-gray-500' }} px-6 py-4 text-sm font-medium border-b-2 hover:text-gray-700 hover:border-gray-300">
                    <i class="fas fa-water mr-2"></i>
                    Cotas Barragens
                </a>
                <a href="?tipo=niveis" class="tab-button {{ $tipo === 'niveis' ? 'active border-blue-500 text-blue-600' : 'border-transparent text-gray-500' }} px-6 py-4 text-sm font-medium border-b-2 hover:text-gray-700 hover:border-gray-300">
                    <i class="fas fa-tint mr-2"></i>
                    Níveis Hidrométricos
                </a>
            </nav>
        </div>

        <!-- Formulário de Filtros -->
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">
                <i class="fas fa-filter mr-2 text-blue-600"></i>
                Filtros
            </h3>

            <form method="GET" action="{{ route('estatisticas.index') }}" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                <input type="hidden" name="tipo" value="{{ $tipo }}">

                @if($tipo === 'precipitacao')
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Estação Pluviométrica</label>
                        <select name="estacao_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200" required>
                            <option value="">Selecione uma estação</option>
                            @foreach($estacoesPluv as $est)
                                <option value="{{ $est->id }}" {{ $selectedId == $est->id ? 'selected' : '' }}>
                                    {{ $est->codigo }} - {{ $est->nome }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                @elseif($tipo === 'cotas')
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Barragem</label>
                        <select name="barragem_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200" required>
                            <option value="">Selecione uma barragem</option>
                            @foreach($barragens as $bar)
                                <option value="{{ $bar->id }}" {{ $selectedId == $bar->id ? 'selected' : '' }}>
                                    {{ $bar->nome }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                @else
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Estação Hidrométrica</label>
                        <select name="estacao_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200" required>
                            <option value="">Selecione uma estação</option>
                            @foreach($estacoesHidro as $est)
                                <option value="{{ $est->id }}" {{ $selectedId == $est->id ? 'selected' : '' }}>
                                    {{ $est->codigo }} - {{ $est->nome }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                @endif

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Período</label>
                    <select name="periodo" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                        <option value="diario" {{ $periodo == 'diario' ? 'selected' : '' }}>Diário</option>
                        <option value="semanal" {{ $periodo == 'semanal' ? 'selected' : '' }}>Semanal</option>
                        <option value="mensal" {{ $periodo == 'mensal' ? 'selected' : '' }}>Mensal</option>
                        <option value="anual" {{ $periodo == 'anual' ? 'selected' : '' }}>Anual</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                    <input type="date" name="data_inicio" value="{{ is_string($dataInicio) ? $dataInicio : $dataInicio->format('Y-m-d') }}"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                    <input type="date" name="data_fim" value="{{ is_string($dataFim) ? $dataFim : $dataFim->format('Y-m-d') }}"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                </div>

                <div class="flex items-end">
                    <button type="submit" class="w-full bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors">
                        <i class="fas fa-search mr-2"></i>
                        Calcular
                    </button>
                </div>
            </form>
        </div>
    </div>

    @if($selectedId && count($medias) > 0)
        <!-- Botões de Exportação -->
        <div class="bg-white rounded-lg shadow p-4 mb-6">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-download mr-2 text-blue-600"></i>
                    Exportar Dados
                </h3>
                <div class="flex space-x-3">
                    <a href="{{ route('estatisticas.exportar-excel', request()->all()) }}"
                       class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-150 shadow-sm">
                        <i class="fas fa-file-excel mr-2"></i>
                        Exportar Excel
                    </a>
                    <a href="{{ route('estatisticas.exportar-pdf', request()->all()) }}"
                       class="inline-flex items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors duration-150 shadow-sm">
                        <i class="fas fa-file-pdf mr-2"></i>
                        Exportar PDF
                    </a>
                </div>
            </div>
        </div>

        <!-- Cards de Resumo -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-blue-100 rounded-full p-3">
                        <i class="fas fa-chart-line text-2xl text-blue-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Média Geral</p>
                        <p class="text-2xl font-bold text-gray-900">
                            {{ number_format($medias->avg('media'), 2) }}
                            {{ $tipo === 'precipitacao' ? 'mm' : 'm' }}
                        </p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-green-100 rounded-full p-3">
                        <i class="fas fa-arrow-up text-2xl text-green-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Máximo</p>
                        <p class="text-2xl font-bold text-gray-900">
                            {{ number_format($medias->max('maximo'), 2) }}
                            {{ $tipo === 'precipitacao' ? 'mm' : 'm' }}
                        </p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-yellow-100 rounded-full p-3">
                        <i class="fas fa-arrow-down text-2xl text-yellow-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Mínimo</p>
                        <p class="text-2xl font-bold text-gray-900">
                            {{ number_format($medias->min('minimo'), 2) }}
                            {{ $tipo === 'precipitacao' ? 'mm' : 'm' }}
                        </p>
                    </div>
                </div>
            </div>

            @if($tipo === 'precipitacao')
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-purple-100 rounded-full p-3">
                        <i class="fas fa-cloud text-2xl text-purple-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Total Acumulado</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($medias->sum('total'), 2) }} mm</p>
                    </div>
                </div>
            </div>
            @else
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-purple-100 rounded-full p-3">
                        <i class="fas fa-list text-2xl text-purple-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Total Leituras</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $medias->sum('leituras') }}</p>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Gráfico -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-chart-bar mr-2 text-blue-600"></i>
                    Gráfico de Médias
                </h3>
            </div>
            <div class="p-6">
                <canvas id="chartEstatisticas" style="max-height: 400px;"></canvas>
            </div>
        </div>

        <!-- Tabela de Dados -->
        <div class="bg-white rounded-lg shadow-lg border border-gray-200">
            <div class="px-6 py-4 border-b border-gray-200 bg-gradient-to-r from-blue-50 to-indigo-50">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-table mr-2 text-blue-600"></i>
                    Dados Detalhados
                </h3>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-800">
                        <tr>
                            <th class="px-6 py-4 text-left text-xs font-bold uppercase tracking-wider text-white">
                                <i class="fas fa-calendar-alt mr-2"></i>
                                Período
                            </th>
                            <th class="px-6 py-4 text-center text-xs font-bold uppercase tracking-wider text-white">
                                <i class="fas fa-chart-line mr-1"></i>
                                Média {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}
                            </th>
                            @if($tipo === 'precipitacao')
                            <th class="px-6 py-4 text-center text-xs font-bold uppercase tracking-wider text-white">
                                <i class="fas fa-cloud-showers-heavy mr-1"></i>
                                Total (mm)
                            </th>
                            @endif
                            <th class="px-6 py-4 text-center text-xs font-bold uppercase tracking-wider text-white">
                                <i class="fas fa-arrow-down mr-1"></i>
                                Mínimo {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}
                            </th>
                            <th class="px-6 py-4 text-center text-xs font-bold uppercase tracking-wider text-white">
                                <i class="fas fa-arrow-up mr-1"></i>
                                Máximo {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}
                            </th>
                            <th class="px-6 py-4 text-center text-xs font-bold uppercase tracking-wider text-white">
                                <i class="fas fa-list-ol mr-1"></i>
                                Nº Leituras
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($medias as $media)
                            <tr class="hover:bg-blue-50 transition-colors duration-150">
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900 border-r border-gray-100">
                                    <div class="flex items-center">
                                        <i class="fas fa-calendar text-blue-500 mr-2"></i>
                                        @if(isset($media->data))
                                            {{ \Carbon\Carbon::parse($media->data)->format('d/m/Y') }}
                                        @elseif(isset($media->semana))
                                            Semana {{ $media->semana }}/{{ $media->ano }}
                                        @elseif(isset($media->mes))
                                            {{ \Carbon\Carbon::create($media->ano, $media->mes)->format('F/Y') }}
                                        @else
                                            {{ $media->ano }}
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm bg-blue-50">
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-bold bg-blue-600 text-white shadow-sm">
                                        {{ number_format($media->media, 2) }}
                                    </span>
                                </td>
                                @if($tipo === 'precipitacao')
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                                    <span class="font-semibold text-purple-600">{{ number_format($media->total, 2) }}</span>
                                </td>
                                @endif
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                                    <span class="inline-flex items-center px-2 py-1 rounded-md bg-yellow-100 text-yellow-800 font-semibold">
                                        <i class="fas fa-arrow-down text-xs mr-1"></i>
                                        {{ number_format($media->minimo, 2) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                                    <span class="inline-flex items-center px-2 py-1 rounded-md bg-green-100 text-green-800 font-semibold">
                                        <i class="fas fa-arrow-up text-xs mr-1"></i>
                                        {{ number_format($media->maximo, 2) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                                    <span class="inline-flex items-center px-2 py-1 rounded-md bg-gray-100 text-gray-700 font-medium">
                                        {{ $media->leituras }}
                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
        const ctx = document.getElementById('chartEstatisticas').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($graficoLabels) !!},
                datasets: [{
                    label: '{{ $tipo === "precipitacao" ? "Média de Precipitação (mm)" : ($tipo === "cotas" ? "Média de Cotas (m)" : "Média de Níveis (m)") }}',
                    data: {!! json_encode($graficoDados) !!},
                    backgroundColor: 'rgba(59, 130, 246, 0.7)',
                    borderColor: 'rgb(59, 130, 246)',
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    title: {
                        display: true,
                        text: '{{ $tipo === "precipitacao" ? "Precipitação" : ($tipo === "cotas" ? "Cotas de Barragens" : "Níveis Hidrométricos") }} - {{ ucfirst($periodo) }}'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value + ' {{ $tipo === "precipitacao" ? "mm" : "m" }}';
                            }
                        }
                    }
                }
            }
        });
        </script>
    @elseif($selectedId)
        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-6 text-center">
            <i class="fas fa-exclamation-triangle text-yellow-600 text-3xl mb-3"></i>
            <p class="text-yellow-800 font-medium">Nenhum dado encontrado para o período selecionado.</p>
        </div>
    @else
        <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 text-center">
            <i class="fas fa-info-circle text-blue-600 text-3xl mb-3"></i>
            <p class="text-blue-800 font-medium">Selecione uma {{ $tipo === 'cotas' ? 'barragem' : 'estação' }} e clique em "Calcular" para visualizar os gráficos.</p>
        </div>
    @endif
</div>

<style>
    .tab-button {
        transition: all 0.2s ease;
    }

    .tab-button:hover {
        background-color: #f9fafb;
    }
</style>
@endsection
