<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Estatísticas - {{ ucfirst($tipo) }}</title>
    <style>
        @page {
            margin: 10mm;
        }
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 10px;
            margin: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 3px solid #1F2937;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #1F2937;
            font-size: 20px;
        }
        .header p {
            margin: 3px 0;
            color: #6B7280;
            font-size: 11px;
        }
        .info-box {
            background-color: #F3F4F6;
            padding: 8px;
            border-radius: 5px;
            margin-bottom: 10px;
            font-size: 9px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        th {
            background-color: #1F2937;
            color: white;
            padding: 6px 4px;
            text-align: center;
            font-weight: bold;
            font-size: 8px;
            text-transform: uppercase;
        }
        td {
            padding: 4px 3px;
            text-align: center;
            border-bottom: 1px solid #E5E7EB;
            font-size: 8px;
        }
        tr:nth-child(even) {
            background-color: #F9FAFB;
        }
        .media-col {
            font-weight: bold;
            color: #2563EB;
            background-color: #EFF6FF;
        }
        .chart-container {
            margin: 15px 0;
            page-break-inside: avoid;
        }
        .chart-title {
            color: #1F2937;
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 10px;
            text-align: center;
        }
        .bar-chart {
            width: 100%;
            max-width: 945px;
            background: white;
            border: 1px solid #D1D5DB;
            padding: 10px;
            margin-bottom: 15px;
            overflow: hidden;
        }
        .chart-wrapper {
            border-left: 2px solid #374151;
            border-bottom: 2px solid #374151;
            padding: 5px 0 0 5px;
            background: #FAFAFA;
        }
        .bar-container {
            display: table;
            width: 100%;
            height: 150px;
            border-spacing: 0;
        }
        .bar-wrapper {
            display: table-cell;
            vertical-align: bottom;
            text-align: center;
            width: auto;
            padding: 0 1px;
        }
        .bar {
            background-color: #3B82F6;
            width: 4px;
            margin: 0 auto;
        }
        .bar-labels {
            display: table;
            width: 100%;
            border-spacing: 0;
            margin-top: 3px;
        }
        .bar-label {
            display: table-cell;
            text-align: center;
            font-size: 5px;
            color: #6B7280;
            width: auto;
            padding: 2px 1px 0 1px;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 8px;
            color: #9CA3AF;
            border-top: 1px solid #E5E7EB;
            padding-top: 8px;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho -->
    <div class="header">
        <h1>ESTATÍSTICAS - {{ strtoupper($tipo) }}</h1>
        <p><strong>{{ $entidadeNome }}</strong></p>
        <p>Período: {{ ucfirst($periodo) }} | {{ is_string($dataInicio) ? $dataInicio : $dataInicio->format('d/m/Y') }} - {{ is_string($dataFim) ? $dataFim : $dataFim->format('d/m/Y') }}</p>
        <p style="font-size: 9px;">Gerado em: {{ \Carbon\Carbon::now()->format('d/m/Y H:i:s') }}</p>
    </div>

    @if(count($medias) > 0)
    <!-- Resumo -->
    <div class="info-box">
        <strong>Resumo Estatístico:</strong>
        Média Geral: {{ number_format($medias->avg('media'), 2) }} {{ $tipo === 'precipitacao' ? 'mm' : 'm' }} |
        Máximo: {{ number_format($medias->max('maximo'), 2) }} {{ $tipo === 'precipitacao' ? 'mm' : 'm' }} |
        Mínimo: {{ number_format($medias->min('minimo'), 2) }} {{ $tipo === 'precipitacao' ? 'mm' : 'm' }} |
        Total Leituras: {{ $medias->sum('leituras') }}
        @if($tipo === 'precipitacao')
        | Precip. Acumulada: {{ number_format($medias->sum('total'), 2) }} mm
        @endif
    </div>

    <!-- Gráfico -->
    <div class="chart-container">
        <div class="chart-title">Gráfico de Médias ({{ $tipo === 'precipitacao' ? 'mm' : 'm' }})</div>

        @php
            $totalDados = count($graficoDados);
            // Mostrar todos os dados no gráfico
            $maxBars = $totalDados;

            // Criar configuração Chart.js idêntica à da tela
            $chartConfig = [
                'type' => 'bar',
                'data' => [
                    'labels' => $graficoLabels,
                    'datasets' => [[
                        'label' => $tipo === 'precipitacao' ? 'Média de Precipitação (mm)' : ($tipo === 'cotas' ? 'Média de Cotas (m)' : 'Média de Níveis (m)'),
                        'data' => $graficoDados,
                        'backgroundColor' => 'rgba(59, 130, 246, 0.7)',
                        'borderColor' => 'rgb(59, 130, 246)',
                        'borderWidth' => 2
                    ]]
                ],
                'options' => [
                    'responsive' => true,
                    'maintainAspectRatio' => false,
                    'plugins' => [
                        'legend' => [
                            'display' => true,
                            'position' => 'top'
                        ],
                        'title' => [
                            'display' => true,
                            'text' => ($tipo === 'precipitacao' ? 'Precipitação' : ($tipo === 'cotas' ? 'Cotas de Barragens' : 'Níveis Hidrométricos')) . ' - ' . ucfirst($periodo)
                        ]
                    ],
                    'scales' => [
                        'y' => [
                            'beginAtZero' => true,
                            'grid' => [
                                'display' => true
                            ]
                        ],
                        'x' => [
                            'grid' => [
                                'display' => false
                            ]
                        ]
                    ]
                ]
            ];

            // Codificar para URL do QuickChart
            $chartConfigJson = json_encode($chartConfig);
            $chartUrl = 'https://quickchart.io/chart?width=900&height=400&c=' . urlencode($chartConfigJson);
        @endphp

        <div style="text-align: center; padding: 20px;">
            <img src="{{ $chartUrl }}" alt="Gráfico de Médias" style="max-width: 100%; height: auto;">
        </div>

        @if($totalDados > 150)
        <div style="margin-top: 5px; font-size: 7px; color: #DC2626; text-align: center;">
            <strong>Nota:</strong> Gráfico com {{ $totalDados }} registros - pode estar comprimido
        </div>
        @endif
    </div>

    <!-- Tabela -->
    <h3 style="color: #1F2937; font-size: 12px; margin-top: 15px;">Dados Detalhados</h3>
    @php
        // Mostrar todos os dados (igual ao gráfico)
        $limitedMedias = $medias;
    @endphp
    <table>
        <thead>
            <tr>
                <th>Período</th>
                <th>Média {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}</th>
                @if($tipo === 'precipitacao')
                <th>Total (mm)</th>
                @endif
                <th>Mínimo {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}</th>
                <th>Máximo {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}</th>
                <th>Leituras</th>
            </tr>
        </thead>
        <tbody>
            @foreach($limitedMedias as $media)
            <tr>
                <td>
                    @if(isset($media->data))
                        {{ \Carbon\Carbon::parse($media->data)->format('d/m/Y') }}
                    @elseif(isset($media->semana))
                        Sem {{ $media->semana }}/{{ $media->ano }}
                    @elseif(isset($media->mes))
                        {{ \Carbon\Carbon::create($media->ano, $media->mes)->format('M/Y') }}
                    @else
                        {{ $media->ano }}
                    @endif
                </td>
                <td class="media-col">{{ number_format($media->media, 2) }}</td>
                @if($tipo === 'precipitacao')
                <td>{{ number_format($media->total, 2) }}</td>
                @endif
                <td>{{ number_format($media->minimo, 2) }}</td>
                <td>{{ number_format($media->maximo, 2) }}</td>
                <td>{{ $media->leituras }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @else
    <div class="info-box" style="text-align: center; color: #DC2626;">
        <strong>Nenhum dado disponível para o período selecionado.</strong>
    </div>
    @endif

    <!-- Rodapé -->
    <div class="footer">
        <p>Sistema Hidrológico - Gestão de Barragens e Estações | Moçambique</p>
    </div>
</body>
</html>
