@extends('layouts.app')

@section('title', 'Nova Área de Jurisdição')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-plus-circle mr-3 text-blue-600"></i>
                    Nova Área de Jurisdição
                </h1>
                <p class="text-gray-600 mt-2">Definir nova área de jurisdição com limites geográficos</p>
            </div>
            <a href="{{ route('jurisdicao.areas') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar
            </a>
        </div>
    </div>

    <!-- Formulário -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-edit mr-2 text-blue-600"></i>
                Informações da Área
            </h3>
        </div>

        <form method="POST" action="{{ route('jurisdicao.areas.store') }}" class="p-6">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Nome -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Nome da Área <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="nome" required
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: Região Norte, Zona Costeira, etc.">
                    @error('nome')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Código -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Código <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="codigo" required
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: AREA-NORTE-001">
                    @error('codigo')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                    <p class="text-xs text-gray-500 mt-1">Código único de identificação</p>
                </div>

                <!-- Área Total -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Área Total (km²) <span class="text-red-500">*</span>
                    </label>
                    <input type="number" name="area_total_km2" step="0.01" required
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: 50000.00">
                    @error('area_total_km2')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Responsável -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Responsável
                    </label>
                    <input type="text" name="responsavel"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Nome do responsável pela área">
                    @error('responsavel')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Contato -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Contato (Telefone)
                    </label>
                    <input type="text" name="contato"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: +258 84 123 4567">
                    @error('contato')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Email -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Email
                    </label>
                    <input type="email" name="email"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="responsavel@exemplo.com">
                    @error('email')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Descrição -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Descrição
                    </label>
                    <textarea name="descricao" rows="3"
                              class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                              placeholder="Informações adicionais sobre a área de jurisdição"></textarea>
                    @error('descricao')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Limites Geográficos (GeoJSON) -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Limites Geográficos (GeoJSON) <span class="text-red-500">*</span>
                    </label>
                    <textarea name="limites_geograficos" rows="8" required
                              class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 font-mono text-sm"
                              placeholder='{"type":"Polygon","coordinates":[[[30.0,-10.0],[40.0,-10.0],[40.0,-20.0],[30.0,-20.0],[30.0,-10.0]]]}'></textarea>
                    @error('limites_geograficos')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                    <p class="text-xs text-gray-500 mt-1">
                        Formato GeoJSON válido. Pode usar ferramentas como
                        <a href="https://geojson.io" target="_blank" class="text-blue-600 hover:text-blue-800">geojson.io</a>
                        para criar os limites.
                    </p>
                </div>
            </div>

            <!-- Botões -->
            <div class="flex justify-end space-x-3 mt-6 pt-6 border-t border-gray-200">
                <a href="{{ route('jurisdicao.areas') }}"
                   class="bg-gray-500 text-white px-6 py-2 rounded-md hover:bg-gray-600 transition-colors">
                    <i class="fas fa-times mr-2"></i>
                    Cancelar
                </a>
                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-save mr-2"></i>
                    Salvar Área
                </button>
            </div>
        </form>
    </div>

    <!-- Informações de Ajuda -->
    <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded">
        <div class="flex">
            <i class="fas fa-info-circle text-blue-400 mt-0.5"></i>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-blue-800">Sobre Limites Geográficos</h3>
                <div class="mt-2 text-sm text-blue-700 space-y-2">
                    <p>Os limites geográficos devem ser fornecidos em formato GeoJSON, que é um padrão para representar dados geográficos.</p>
                    <p><strong>Exemplo de polígono simples:</strong></p>
                    <pre class="bg-white p-2 rounded border border-blue-200 overflow-x-auto text-xs mt-1">
{
  "type": "Polygon",
  "coordinates": [
    [
      [30.0, -10.0],
      [40.0, -10.0],
      [40.0, -20.0],
      [30.0, -20.0],
      [30.0, -10.0]
    ]
  ]
}</pre>
                    <p class="mt-2">Você pode usar ferramentas online como <a href="https://geojson.io" target="_blank" class="text-blue-800 underline">geojson.io</a> para desenhar os limites da área de forma visual e obter o GeoJSON correspondente.</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
