@extends('layouts.app')

@section('title', 'Nova Divisão Administrativa')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-plus-circle mr-3 text-blue-600"></i>
                    Nova Divisão Administrativa
                </h1>
                <p class="text-gray-600 mt-2">Cadastrar província, distrito, município, setor ou zona</p>
            </div>
            <a href="{{ route('jurisdicao.divisoes') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar
            </a>
        </div>
    </div>

    <!-- Formulário -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-edit mr-2 text-blue-600"></i>
                Informações da Divisão
            </h3>
        </div>

        <form method="POST" action="{{ route('jurisdicao.divisoes.store') }}" class="p-6">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Nome -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Nome da Divisão <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="nome" required
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: Nampula, Distrito de Meconta, etc.">
                    @error('nome')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Código -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Código <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="codigo" required
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: NAM-001, DIST-NAM-001">
                    @error('codigo')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                    <p class="text-xs text-gray-500 mt-1">Código único de identificação</p>
                </div>

                <!-- Tipo -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Tipo de Divisão <span class="text-red-500">*</span>
                    </label>
                    <select name="tipo" required
                            class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                        <option value="">Selecione o tipo</option>
                        <option value="provincia">Província</option>
                        <option value="distrito">Distrito</option>
                        <option value="municipio">Município</option>
                        <option value="setor">Setor</option>
                        <option value="zona">Zona</option>
                    </select>
                    @error('tipo')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Divisão Pai -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Divisão Pai (opcional)
                    </label>
                    <select name="parent_id"
                            class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                        <option value="">Nenhuma (é nível superior)</option>
                        @foreach($pais as $pai)
                            <option value="{{ $pai->id }}">
                                {{ $pai->nome }} ({{ ucfirst($pai->tipo) }})
                            </option>
                        @endforeach
                    </select>
                    @error('parent_id')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                    <p class="text-xs text-gray-500 mt-1">Ex: Distrito pertence a uma Província</p>
                </div>

                <!-- Área -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Área (km²)
                    </label>
                    <input type="number" name="area_km2" step="0.01"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: 1500.50">
                    @error('area_km2')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Coordenadas -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Latitude
                    </label>
                    <input type="number" name="latitude" step="0.00000001"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: -15.1165">
                    @error('latitude')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Longitude
                    </label>
                    <input type="number" name="longitude" step="0.00000001"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: 39.2666">
                    @error('longitude')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- População -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        População
                    </label>
                    <input type="number" name="populacao"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                           placeholder="Ex: 580000">
                    @error('populacao')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Descrição -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Descrição
                    </label>
                    <textarea name="descricao" rows="4"
                              class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                              placeholder="Informações adicionais sobre a divisão administrativa"></textarea>
                    @error('descricao')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Botões -->
            <div class="flex justify-end space-x-3 mt-6 pt-6 border-t border-gray-200">
                <a href="{{ route('jurisdicao.divisoes') }}"
                   class="bg-gray-500 text-white px-6 py-2 rounded-md hover:bg-gray-600 transition-colors">
                    <i class="fas fa-times mr-2"></i>
                    Cancelar
                </a>
                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-save mr-2"></i>
                    Salvar Divisão
                </button>
            </div>
        </form>
    </div>

    <!-- Informações de Ajuda -->
    <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded">
        <div class="flex">
            <i class="fas fa-info-circle text-blue-400 mt-0.5"></i>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-blue-800">Hierarquia de Divisões</h3>
                <div class="mt-2 text-sm text-blue-700 space-y-1">
                    <p><strong>Província:</strong> Nível administrativo mais alto (ex: Nampula, Cabo Delgado)</p>
                    <p><strong>Distrito:</strong> Subdivisão de uma província (ex: Distrito de Meconta)</p>
                    <p><strong>Município:</strong> Área urbana autônoma</p>
                    <p><strong>Setor:</strong> Subdivisão administrativa menor</p>
                    <p><strong>Zona:</strong> Menor unidade administrativa</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
