@extends('layouts.app')

@section('title', 'Divisões Administrativas')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-layer-group mr-3 text-blue-600"></i>
                    Divisões Administrativas
                </h1>
                <p class="text-gray-600 mt-2">Gerir hierarquia de províncias, distritos, municípios, setores e zonas</p>
            </div>
            <a href="{{ route('jurisdicao.divisoes.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                <i class="fas fa-plus mr-2"></i>
                Nova Divisão
            </a>
        </div>
    </div>

    <!-- Estatísticas -->
    <div class="grid grid-cols-1 md:grid-cols-5 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-center">
                <i class="fas fa-map-marker-alt text-3xl text-red-600 mb-2"></i>
                <p class="text-sm font-medium text-gray-500">Províncias</p>
                <p class="text-3xl font-bold text-gray-900">{{ $stats['provincias'] }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-center">
                <i class="fas fa-map-marked-alt text-3xl text-blue-600 mb-2"></i>
                <p class="text-sm font-medium text-gray-500">Distritos</p>
                <p class="text-3xl font-bold text-gray-900">{{ $stats['distritos'] }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-center">
                <i class="fas fa-city text-3xl text-green-600 mb-2"></i>
                <p class="text-sm font-medium text-gray-500">Municípios</p>
                <p class="text-3xl font-bold text-gray-900">{{ $stats['municipios'] }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-center">
                <i class="fas fa-th-large text-3xl text-purple-600 mb-2"></i>
                <p class="text-sm font-medium text-gray-500">Setores</p>
                <p class="text-3xl font-bold text-gray-900">{{ $stats['setores'] }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-center">
                <i class="fas fa-location-arrow text-3xl text-orange-600 mb-2"></i>
                <p class="text-sm font-medium text-gray-500">Zonas</p>
                <p class="text-3xl font-bold text-gray-900">{{ $stats['zonas'] }}</p>
            </div>
        </div>
    </div>

    <!-- Lista de Divisões por Tipo -->
    @foreach($divisoes as $tipo => $divisoesTipo)
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-folder mr-2 text-blue-600"></i>
                {{ ucfirst($tipo) }}s ({{ $divisoesTipo->count() }})
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-800 text-white">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Código</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Nome</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Divisão Pai</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Área (km²)</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">População</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($divisoesTipo as $divisao)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $divisao->codigo }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $divisao->nome }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $divisao->parent?->nome ?? '-' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">{{ $divisao->area_km2 ? number_format($divisao->area_km2, 2) : '-' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">{{ $divisao->populacao ? number_format($divisao->populacao) : '-' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                            <span class="px-2 py-1 rounded-full text-xs {{ $divisao->ativo ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                {{ $divisao->ativo ? 'Ativo' : 'Inativo' }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endforeach

    @if($divisoes->isEmpty())
    <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded">
        <div class="flex">
            <i class="fas fa-info-circle text-blue-400 mt-0.5"></i>
            <p class="ml-3 text-sm text-blue-700">
                Nenhuma divisão administrativa cadastrada. Clique em "Nova Divisão" para começar.
            </p>
        </div>
    </div>
    @endif
</div>
@endsection
