@extends('layouts.app')

@section('title', 'Inventário de Bacias Hidrográficas')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-clipboard-list mr-3 text-blue-600"></i>
                    Inventário de Bacias Hidrográficas
                </h1>
                <p class="text-gray-600 mt-2">Mapeamento completo de todas as bacias, sub-bacias e rios do sistema</p>
            </div>
            <a href="{{ route('bacias.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                <i class="fas fa-plus mr-2"></i>
                Nova Bacia
            </a>
        </div>
    </div>

    <!-- Estatísticas -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-purple-100 rounded-full p-3">
                    <i class="fas fa-map text-2xl text-purple-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Bacias</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $stats['total_bacias'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-green-100 rounded-full p-3">
                    <i class="fas fa-map-marked-alt text-2xl text-green-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Com Coordenadas</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $stats['bacias_com_coordenadas'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-blue-100 rounded-full p-3">
                    <i class="fas fa-layer-group text-2xl text-blue-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Com Divisão Admin.</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $stats['bacias_com_divisao'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-yellow-100 rounded-full p-3">
                    <i class="fas fa-ruler-combined text-2xl text-yellow-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Área Total</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['area_total_km2'], 0) }} km²</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Lista Completa de Bacias -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-list mr-2 text-blue-600"></i>
                Todas as Bacias Hidrográficas
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-800 text-white">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Código</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Nome</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Divisão Administrativa</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase">Área Jurisdição</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Área (km²)</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Coordenadas</th>
                        <th class="px-6 py-3 text-center text-xs font-medium uppercase">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($bacias as $bacia)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $bacia->codigo }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $bacia->nome }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                            @if($bacia->divisaoAdministrativa)
                                <span class="px-2 py-1 rounded-full text-xs bg-blue-100 text-blue-800">
                                    {{ $bacia->divisaoAdministrativa->nome }}
                                </span>
                            @else
                                <span class="text-gray-400">Não definida</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                            @if($bacia->areaJurisdicao)
                                <span class="px-2 py-1 rounded-full text-xs bg-green-100 text-green-800">
                                    {{ $bacia->areaJurisdicao->nome }}
                                </span>
                            @else
                                <span class="text-gray-400">Não definida</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">
                            {{ $bacia->area_km2 ? number_format($bacia->area_km2, 2) : '-' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                            @if($bacia->coordenadas_geograficas)
                                <span class="px-2 py-1 rounded-full text-xs bg-green-100 text-green-800">
                                    <i class="fas fa-check-circle"></i> Sim
                                </span>
                            @else
                                <span class="px-2 py-1 rounded-full text-xs bg-gray-100 text-gray-800">
                                    <i class="fas fa-times-circle"></i> Não
                                </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm space-x-2">
                            <a href="{{ route('bacias.show', $bacia) }}" class="text-blue-600 hover:text-blue-800">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('bacias.edit', $bacia) }}" class="text-green-600 hover:text-green-800">
                                <i class="fas fa-edit"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="px-6 py-8 text-center text-gray-500">
                            <i class="fas fa-inbox text-4xl mb-3 text-gray-400"></i>
                            <p>Nenhuma bacia cadastrada no sistema.</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Agrupamento por Divisão Administrativa -->
    @if($baciasPorDivisao->count() > 0)
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-layer-group mr-2 text-blue-600"></i>
                Distribuição por Divisão Administrativa
            </h3>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($baciasPorDivisao as $divisaoId => $baciasGrupo)
                    @if($divisaoId)
                        @php
                            $divisao = $baciasGrupo->first()->divisaoAdministrativa;
                        @endphp
                        <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow">
                            <div class="flex items-center justify-between mb-3">
                                <h4 class="font-semibold text-gray-900">{{ $divisao->nome }}</h4>
                                <span class="px-2 py-1 rounded-full text-xs bg-blue-100 text-blue-800">
                                    {{ $baciasGrupo->count() }} {{ $baciasGrupo->count() === 1 ? 'bacia' : 'bacias' }}
                                </span>
                            </div>
                            <div class="text-sm text-gray-600 space-y-1">
                                <p><strong>Tipo:</strong> {{ ucfirst($divisao->tipo) }}</p>
                                <p><strong>Área total:</strong> {{ number_format($baciasGrupo->sum('area_km2'), 2) }} km²</p>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>
    @endif
</div>
@endsection
