@extends('layouts.app')

@section('title', 'Histórico de Notificações')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">
                    <i class="fas fa-history mr-3 text-blue-600"></i>
                    Histórico de Notificações
                </h1>
                <p class="text-gray-600 mt-2">
                    Acompanhe todas as notificações enviadas para sua conta
                </p>
            </div>
            <div class="flex items-center space-x-4">
                <div class="text-right">
                    <p class="text-sm text-gray-500">Total de Notificações</p>
                    <p class="text-2xl font-bold text-blue-600">{{ $notificacoes->total() }}</p>
                </div>
                <a href="{{ route('notifications.config') }}"
                   class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors flex items-center">
                    <i class="fas fa-cog mr-2"></i>
                    Configurações
                </a>
            </div>
        </div>
    </div>

    <!-- Estatísticas Rápidas -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        @php
            $stats = [
                'total' => $notificacoes->total(),
                'enviadas' => $notificacoes->where('status', 'enviado')->count() + $notificacoes->where('status', 'entregue')->count(),
                'falhadas' => $notificacoes->where('status', 'falhado')->count(),
                'pendentes' => $notificacoes->where('status', 'pendente')->count()
            ];
            $taxaEntrega = $stats['total'] > 0 ? round(($stats['enviadas'] / $stats['total']) * 100, 1) : 0;
        @endphp

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Total</p>
                    <p class="text-3xl font-bold text-blue-600">{{ $stats['total'] }}</p>
                    <p class="text-xs text-gray-500">Todas as notificações</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-bell text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Enviadas</p>
                    <p class="text-3xl font-bold text-green-600">{{ $stats['enviadas'] }}</p>
                    <p class="text-xs text-gray-500">{{ $taxaEntrega }}% do total</p>
                </div>
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-check-circle text-2xl text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-red-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Falhadas</p>
                    <p class="text-3xl font-bold text-red-600">{{ $stats['falhadas'] }}</p>
                    <p class="text-xs text-gray-500">Requer atenção</p>
                </div>
                <div class="bg-red-100 p-3 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-2xl text-red-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-yellow-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Pendentes</p>
                    <p class="text-3xl font-bold text-yellow-600">{{ $stats['pendentes'] }}</p>
                    <p class="text-xs text-gray-500">Aguardando envio</p>
                </div>
                <div class="bg-yellow-100 p-3 rounded-lg">
                    <i class="fas fa-clock text-2xl text-yellow-600"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex flex-wrap items-center justify-between gap-4">
            <div class="flex flex-wrap items-center gap-4">
                <select class="border border-gray-300 rounded-lg px-3 py-2 text-sm" id="filtroTipo">
                    <option value="">Todos os Tipos</option>
                    <option value="sms">SMS</option>
                    <option value="email">Email</option>
                </select>

                <select class="border border-gray-300 rounded-lg px-3 py-2 text-sm" id="filtroStatus">
                    <option value="">Todos os Status</option>
                    <option value="pendente">Pendente</option>
                    <option value="enviado">Enviado</option>
                    <option value="entregue">Entregue</option>
                    <option value="falhado">Falhado</option>
                </select>

                <select class="border border-gray-300 rounded-lg px-3 py-2 text-sm" id="filtroCategoria">
                    <option value="">Todas as Categorias</option>
                    <option value="alerta">Alerta</option>
                    <option value="emergencia">Emergência</option>
                    <option value="resolucao">Resolução</option>
                    <option value="escalacao">Escalação</option>
                </select>
            </div>

            <div class="flex items-center gap-2">
                <input type="date" class="border border-gray-300 rounded-lg px-3 py-2 text-sm" id="filtroData">
                <button class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition-colors text-sm">
                    <i class="fas fa-filter mr-2"></i>
                    Filtrar
                </button>
            </div>
        </div>
    </div>

    <!-- Lista de Notificações -->
    <div class="bg-white rounded-lg shadow">
        <div class="p-6 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">
                <i class="fas fa-list mr-2 text-gray-600"></i>
                Notificações Enviadas
            </h3>
        </div>

        @if($notificacoes->count() > 0)
            <div class="divide-y divide-gray-200">
                @foreach($notificacoes as $notificacao)
                    <div class="p-6 hover:bg-gray-50 transition-colors">
                        <div class="flex items-start justify-between">
                            <!-- Conteúdo Principal -->
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center space-x-3 mb-2">
                                    <!-- Ícone do Tipo -->
                                    <div class="flex-shrink-0">
                                        @if($notificacao->tipo === 'sms')
                                            <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                                                <i class="fas fa-sms text-blue-600 text-sm"></i>
                                            </div>
                                        @else
                                            <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center">
                                                <i class="fas fa-envelope text-green-600 text-sm"></i>
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Info da Notificação -->
                                    <div class="min-w-0 flex-1">
                                        <div class="flex items-center space-x-2">
                                            <!-- Badge da Categoria -->
                                            @php
                                                $categoriaColors = [
                                                    'emergencia' => 'bg-red-100 text-red-800',
                                                    'alerta' => 'bg-orange-100 text-orange-800',
                                                    'resolucao' => 'bg-green-100 text-green-800',
                                                    'escalacao' => 'bg-purple-100 text-purple-800'
                                                ];
                                                $categoriaColor = $categoriaColors[$notificacao->categoria] ?? 'bg-gray-100 text-gray-800';
                                            @endphp
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $categoriaColor }}">
                                                @if($notificacao->categoria === 'emergencia')
                                                    🚨 Emergência
                                                @elseif($notificacao->categoria === 'alerta')
                                                    🔔 Alerta
                                                @elseif($notificacao->categoria === 'resolucao')
                                                    ✅ Resolução
                                                @elseif($notificacao->categoria === 'escalacao')
                                                    ⚠️ Escalação
                                                @else
                                                    {{ ucfirst($notificacao->categoria) }}
                                                @endif
                                            </span>

                                            <!-- Status Badge -->
                                            @php
                                                $statusColors = [
                                                    'pendente' => 'bg-yellow-100 text-yellow-800',
                                                    'enviado' => 'bg-blue-100 text-blue-800',
                                                    'entregue' => 'bg-green-100 text-green-800',
                                                    'falhado' => 'bg-red-100 text-red-800'
                                                ];
                                                $statusColor = $statusColors[$notificacao->status] ?? 'bg-gray-100 text-gray-800';
                                            @endphp
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $statusColor }}">
                                                {{ ucfirst($notificacao->status) }}
                                            </span>
                                        </div>

                                        <p class="text-sm text-gray-900 mt-1 font-medium">
                                            @if($notificacao->alerta)
                                                {{ $notificacao->alerta->titulo }}
                                            @else
                                                Notificação do Sistema
                                            @endif
                                        </p>
                                    </div>
                                </div>

                                <!-- Conteúdo da Mensagem -->
                                <div class="ml-11">
                                    <div class="bg-gray-50 rounded-lg p-3 mt-2">
                                        <p class="text-sm text-gray-700">
                                            {{ Str::limit($notificacao->conteudo, 150) }}
                                        </p>
                                        @if(strlen($notificacao->conteudo) > 150)
                                            <button class="text-blue-600 text-xs hover:text-blue-800 mt-1"
                                                    onclick="toggleContent({{ $notificacao->id }})">
                                                Ver mais...
                                            </button>
                                            <div id="content-{{ $notificacao->id }}" class="hidden mt-2 text-sm text-gray-700">
                                                {{ $notificacao->conteudo }}
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Informações Adicionais -->
                                    <div class="flex items-center justify-between mt-3 text-xs text-gray-500">
                                        <div class="flex items-center space-x-4">
                                            <span>
                                                <i class="fas fa-calendar mr-1"></i>
                                                {{ $notificacao->created_at->format('d/m/Y H:i') }}
                                            </span>
                                            <span>
                                                <i class="fas fa-paper-plane mr-1"></i>
                                                {{ $notificacao->destinatario }}
                                            </span>
                                            @if($notificacao->alerta)
                                                <span>
                                                    <i class="fas fa-map-marker-alt mr-1"></i>
                                                    {{ $notificacao->alerta->getNomeInfrastrutura() }}
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Ações -->
                                        <div class="flex items-center space-x-2">
                                            @if($notificacao->status === 'falhado')
                                                <form method="POST" action="{{ route('notifications.reenviar', $notificacao) }}" class="inline">
                                                    @csrf
                                                    <button type="submit"
                                                            class="text-blue-600 hover:text-blue-800 text-xs"
                                                            onclick="return confirm('Deseja reenviar esta notificação?')">
                                                        <i class="fas fa-redo mr-1"></i>
                                        Reenviar
                                                    </button>
                                                </form>
                                            @endif

                                            @if($notificacao->external_id)
                                                <span class="text-gray-400">
                                                    <i class="fas fa-info-circle mr-1"></i>
                                                    ID: {{ Str::limit($notificacao->external_id, 8) }}
                                                </span>
                                            @endif
                                        </div>
                                    </div>

                                    <!-- Erro (se houver) -->
                                    @if($notificacao->status === 'falhado' && $notificacao->erro_detalhes)
                                        <div class="mt-2 p-2 bg-red-50 border border-red-200 rounded text-xs text-red-700">
                                            <strong>Erro:</strong> {{ $notificacao->erro_detalhes }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Paginação -->
            <div class="p-6 border-t border-gray-200">
                {{ $notificacoes->links() }}
            </div>
        @else
            <!-- Estado Vazio -->
            <div class="p-12 text-center">
                <div class="w-24 h-24 mx-auto bg-gray-100 rounded-full flex items-center justify-center mb-4">
                    <i class="fas fa-bell-slash text-3xl text-gray-400"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Nenhuma notificação encontrada</h3>
                <p class="text-gray-500 mb-6">
                    Você ainda não recebeu nenhuma notificação do sistema.
                </p>
                <a href="{{ route('notifications.config') }}"
                   class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                    <i class="fas fa-cog mr-2"></i>
                    Configurar Notificações
                </a>
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
function toggleContent(id) {
    const element = document.getElementById('content-' + id);
    element.classList.toggle('hidden');
}

// Filtros básicos (podem ser expandidos com AJAX)
document.addEventListener('DOMContentLoaded', function() {
    const filtros = {
        tipo: document.getElementById('filtroTipo'),
        status: document.getElementById('filtroStatus'),
        categoria: document.getElementById('filtroCategoria'),
        data: document.getElementById('filtroData')
    };

    // Aplicar filtros quando mudar (implementação básica)
    Object.values(filtros).forEach(filtro => {
        if (filtro) {
            filtro.addEventListener('change', function() {
                // Implementar filtros via AJAX se necessário
                // Por agora, apenas reload da página com parâmetros
                const url = new URL(window.location);
                if (this.value) {
                    url.searchParams.set(this.id.replace('filtro', '').toLowerCase(), this.value);
                } else {
                    url.searchParams.delete(this.id.replace('filtro', '').toLowerCase());
                }
                window.location = url;
            });
        }
    });
});
</script>
@endpush

@push('styles')
<style>
.notification-item:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.badge-pulse {
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% {
        opacity: 1;
    }
    50% {
        opacity: 0.7;
    }
}
</style>
@endpush
@endsection