@extends('layouts.app')

@section('title', 'Nova Coleta - QA Global')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-plus-circle mr-3 text-blue-600"></i>
                    Nova Coleta de Qualidade de Água
                </h1>
                <p class="text-gray-600 mt-2">Preencha os dados da coleta para cálculo automático do IQA</p>
            </div>
            <a href="{{ route('qa-global.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar
            </a>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-50 border-l-4 border-red-400 p-4 rounded">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-exclamation-triangle text-red-400"></i>
                </div>
                <div class="ml-3">
                    <h3 class="text-sm font-medium text-red-800">Erros de Validação:</h3>
                    <ul class="mt-2 text-sm text-red-700 list-disc list-inside">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('qa-global.store') }}" method="POST" id="formColeta">
        @csrf

        <!-- Progresso das Etapas -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex space-x-2" id="etapasNav" role="tablist">
                <button type="button" class="flex-1 px-4 py-3 text-center rounded-md transition-colors bg-blue-600 text-white font-semibold"
                        id="etapa1-tab" data-etapa="1" onclick="mostrarEtapa(1)">
                    <i class="fas fa-info-circle mr-2"></i>
                    <span class="hidden sm:inline">1. Dados Gerais</span>
                    <span class="sm:hidden">1</span>
                </button>
                <button type="button" class="flex-1 px-4 py-3 text-center rounded-md transition-colors bg-gray-200 text-gray-700 hover:bg-gray-300"
                        id="etapa2-tab" data-etapa="2" onclick="mostrarEtapa(2)">
                    <i class="fas fa-flask mr-2"></i>
                    <span class="hidden sm:inline">2. Parâmetros F-Q</span>
                    <span class="sm:hidden">2</span>
                </button>
                <button type="button" class="flex-1 px-4 py-3 text-center rounded-md transition-colors bg-gray-200 text-gray-700 hover:bg-gray-300"
                        id="etapa3-tab" data-etapa="3" onclick="mostrarEtapa(3)">
                    <i class="fas fa-radiation mr-2"></i>
                    <span class="hidden sm:inline">3. Metais Pesados</span>
                    <span class="sm:hidden">3</span>
                </button>
                <button type="button" class="flex-1 px-4 py-3 text-center rounded-md transition-colors bg-gray-200 text-gray-700 hover:bg-gray-300"
                        id="etapa4-tab" data-etapa="4" onclick="mostrarEtapa(4)">
                    <i class="fas fa-check-circle mr-2"></i>
                    <span class="hidden sm:inline">4. Revisão</span>
                    <span class="sm:hidden">4</span>
                </button>
            </div>
        </div>

        <!-- Etapa 1: Dados Gerais -->
        <div id="etapa1" class="etapa-content">
            <div class="bg-white rounded-lg shadow">
                <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                    <h3 class="text-lg font-semibold text-gray-900">
                        <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                        Dados Gerais da Coleta
                    </h3>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div class="lg:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Estação <span class="text-red-600">*</span>
                            </label>
                            <select name="estacao_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200" required>
                                <option value="">Selecione uma estação</option>
                                @foreach($estacoes as $estacao)
                                    <option value="{{ $estacao->id }}" {{ old('estacao_id') == $estacao->id ? 'selected' : '' }}>
                                        {{ $estacao->codigo }} - {{ $estacao->bacia_hidrografica->nome ?? '' }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Data da Coleta <span class="text-red-600">*</span>
                            </label>
                            <input type="date" name="data_coleta" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('data_coleta', date('Y-m-d')) }}" required>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Hora da Coleta</label>
                            <input type="time" name="hora_coleta" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('hora_coleta', date('H:i')) }}">
                        </div>

                        <div class="lg:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Responsável pela Coleta</label>
                            <input type="text" name="responsavel" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('responsavel') }}" placeholder="Nome do responsável">
                        </div>

                        <div class="lg:col-span-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Observações</label>
                            <textarea name="observacoes" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                      rows="3" placeholder="Observações sobre a coleta, condições climáticas, etc.">{{ old('observacoes') }}</textarea>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-end">
                        <button type="button" class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors" onclick="proximaEtapa(2)">
                            Próxima Etapa <i class="fas fa-arrow-right ml-2"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Etapa 2: Parâmetros Físico-Químicos -->
        <div id="etapa2" class="etapa-content hidden">
            <div class="bg-white rounded-lg shadow">
                <div class="px-6 py-4 border-b border-gray-200 bg-cyan-50">
                    <h3 class="text-lg font-semibold text-gray-900">
                        <i class="fas fa-flask mr-2 text-cyan-600"></i>
                        Parâmetros Físico-Químicos
                    </h3>
                </div>
                <div class="p-6">
                    <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded mb-6">
                        <div class="flex">
                            <i class="fas fa-info-circle text-blue-400 mt-0.5"></i>
                            <p class="ml-3 text-sm text-blue-700">
                                Preencha os parâmetros medidos. Campos vazios serão ignorados no cálculo do IQA.
                            </p>
                        </div>
                    </div>

                    <!-- Parâmetros para IQA -->
                    <div class="mb-6">
                        <h4 class="text-md font-semibold text-blue-700 border-b-2 border-blue-200 pb-2 mb-4">
                            <i class="fas fa-star mr-2"></i>Parâmetros do IQA
                        </h4>

                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Oxigênio Dissolvido (%)
                                    <i class="fas fa-question-circle text-blue-400 cursor-help" title="Saturação de oxigênio dissolvido na água"></i>
                                </label>
                                <input type="number" step="0.01" name="oxigenio_dissolvido" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('oxigenio_dissolvido') }}" data-limite-min="0" data-limite-max="200">
                                <small class="text-gray-500 text-xs">Ideal: 85-100%</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Coliformes Fecais (NMP/100mL)
                                    <i class="fas fa-question-circle text-blue-400 cursor-help" title="Número Mais Provável de coliformes por 100mL"></i>
                                </label>
                                <input type="number" name="coliformes_fecais" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('coliformes_fecais') }}" data-limite-max="1000">
                                <small class="text-gray-500 text-xs">Máx: 1000 NMP/100mL</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">pH</label>
                                <input type="number" step="0.01" name="ph" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('ph') }}"
                                       data-limite-min="{{ $limites['ph']->limite_minimo ?? 6.5 }}"
                                       data-limite-max="{{ $limites['ph']->limite_maximo ?? 8.5 }}">
                                <small class="text-gray-500 text-xs">Faixa: {{ $limites['ph']->limite_minimo ?? 6.5 }} - {{ $limites['ph']->limite_maximo ?? 8.5 }}</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">DBO (mg/L)</label>
                                <input type="number" step="0.01" name="dbo" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('dbo') }}" data-limite-max="10">
                                <small class="text-gray-500 text-xs">Máx: 10 mg/L</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Nitrogênio Total (mg/L)</label>
                                <input type="number" step="0.0001" name="nitrogenio_total" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('nitrogenio_total') }}" data-limite-max="10">
                                <small class="text-gray-500 text-xs">Máx: 10 mg/L</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Fosfato Total (mg/L)</label>
                                <input type="number" step="0.0001" name="fosfato_total" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('fosfato_total') }}"
                                       data-limite-max="{{ $limites['fosfato']->limite_maximo ?? 0.1 }}">
                                <small class="text-gray-500 text-xs">Máx: {{ $limites['fosfato']->limite_maximo ?? 0.1 }} mg/L</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Turbidez (NTU)</label>
                                <input type="number" step="0.01" name="turbidez" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('turbidez') }}" data-limite-max="100">
                                <small class="text-gray-500 text-xs">Máx: 100 NTU</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Sólidos Totais (mg/L)</label>
                                <input type="number" name="solidos_totais" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('solidos_totais') }}" data-limite-max="500">
                                <small class="text-gray-500 text-xs">Máx: 500 mg/L</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Temperatura (°C)</label>
                                <input type="number" step="0.01" name="temperatura" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('temperatura') }}"
                                       data-limite-min="{{ $limites['temperatura']->limite_minimo ?? 25 }}"
                                       data-limite-max="{{ $limites['temperatura']->limite_maximo ?? 40 }}">
                                <small class="text-gray-500 text-xs">Faixa: {{ $limites['temperatura']->limite_minimo ?? 25 }} - {{ $limites['temperatura']->limite_maximo ?? 40 }}°C</small>
                            </div>
                        </div>
                    </div>

                    <!-- Parâmetros Adicionais -->
                    <div class="mb-6">
                        <h4 class="text-md font-semibold text-gray-600 border-b-2 border-gray-200 pb-2 mb-4">
                            <i class="fas fa-plus mr-2"></i>Parâmetros Adicionais
                        </h4>

                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Condutividade Elétrica (µS/cm)</label>
                                <input type="number" name="condutividade_eletrica" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('condutividade_eletrica') }}"
                                       data-limite-min="{{ $limites['condutividade_eletrica']->limite_minimo ?? 50 }}"
                                       data-limite-max="{{ $limites['condutividade_eletrica']->limite_maximo ?? 2000 }}">
                                <small class="text-gray-500 text-xs">Faixa: {{ $limites['condutividade_eletrica']->limite_minimo ?? 50 }} - {{ $limites['condutividade_eletrica']->limite_maximo ?? 2000 }} µS/cm</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">TDS (mg/L)</label>
                                <input type="number" name="tds" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('tds') }}"
                                       data-limite-max="{{ $limites['tds']->limite_maximo ?? 1000 }}">
                                <small class="text-gray-500 text-xs">Máx: {{ $limites['tds']->limite_maximo ?? 1000 }} mg/L</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Nitrato (mg/L)</label>
                                <input type="number" step="0.0001" name="nitrato" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('nitrato') }}"
                                       data-limite-max="{{ $limites['nitrato']->limite_maximo ?? 50 }}">
                                <small class="text-gray-500 text-xs">Máx: {{ $limites['nitrato']->limite_maximo ?? 50 }} mg/L</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Fosfato (mg/L)</label>
                                <input type="number" step="0.0001" name="fosfato" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('fosfato') }}"
                                       data-limite-max="{{ $limites['fosfato']->limite_maximo ?? 0.1 }}">
                                <small class="text-gray-500 text-xs">Máx: {{ $limites['fosfato']->limite_maximo ?? 0.1 }} mg/L</small>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Cloretos (mg/L)</label>
                                <input type="number" step="0.0001" name="cloretos" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                       value="{{ old('cloretos') }}"
                                       data-limite-max="{{ $limites['cloretos']->limite_maximo ?? 250 }}">
                                <small class="text-gray-500 text-xs">Máx: {{ $limites['cloretos']->limite_maximo ?? 250 }} mg/L</small>
                            </div>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-between">
                        <button type="button" class="bg-gray-500 text-white px-6 py-2 rounded-md hover:bg-gray-600 transition-colors" onclick="proximaEtapa(1)">
                            <i class="fas fa-arrow-left mr-2"></i>Voltar
                        </button>
                        <button type="button" class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors" onclick="proximaEtapa(3)">
                            Próxima Etapa <i class="fas fa-arrow-right ml-2"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Etapa 3: Metais Pesados -->
        <div id="etapa3" class="etapa-content hidden">
            <div class="bg-white rounded-lg shadow">
                <div class="px-6 py-4 border-b border-gray-200 bg-yellow-50">
                    <h3 class="text-lg font-semibold text-gray-900">
                        <i class="fas fa-radiation mr-2 text-yellow-600"></i>
                        Metais Pesados
                    </h3>
                </div>
                <div class="p-6">
                    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded mb-6">
                        <div class="flex">
                            <i class="fas fa-exclamation-triangle text-yellow-400 mt-0.5"></i>
                            <p class="ml-3 text-sm text-yellow-700">
                                Metais pesados têm limites muito baixos. Valores acima dos limites indicam contaminação.
                            </p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Ferro (Fe) - mg/L</label>
                            <input type="number" step="0.00001" name="ferro" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                   value="{{ old('ferro') }}"
                                   data-limite-max="{{ $limites['ferro']->limite_maximo ?? 0.3 }}">
                            <small class="text-gray-500 text-xs">Máx: {{ $limites['ferro']->limite_maximo ?? 0.3 }} mg/L</small>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Chumbo (Pb) - mg/L</label>
                            <input type="number" step="0.00001" name="chumbo" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                   value="{{ old('chumbo') }}"
                                   data-limite-max="{{ $limites['chumbo']->limite_maximo ?? 0.01 }}">
                            <small class="text-red-600 text-xs">Máx: {{ $limites['chumbo']->limite_maximo ?? 0.01 }} mg/L</small>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Cádmio (Cd) - mg/L</label>
                            <input type="number" step="0.000001" name="cadmio" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                   value="{{ old('cadmio') }}"
                                   data-limite-max="{{ $limites['cadmio']->limite_maximo ?? 0.003 }}">
                            <small class="text-red-600 text-xs">Máx: {{ $limites['cadmio']->limite_maximo ?? 0.003 }} mg/L</small>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Zinco (Zn) - mg/L</label>
                            <input type="number" step="0.00001" name="zinco" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                   value="{{ old('zinco') }}"
                                   data-limite-max="{{ $limites['zinco']->limite_maximo ?? 3 }}">
                            <small class="text-gray-500 text-xs">Máx: {{ $limites['zinco']->limite_maximo ?? 3 }} mg/L</small>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Cobre (Cu) - mg/L</label>
                            <input type="number" step="0.00001" name="cobre" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                   value="{{ old('cobre') }}"
                                   data-limite-max="{{ $limites['cobre']->limite_maximo ?? 1 }}">
                            <small class="text-gray-500 text-xs">Máx: {{ $limites['cobre']->limite_maximo ?? 1 }} mg/L</small>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Arsênio (As) - mg/L</label>
                            <input type="number" step="0.00001" name="arsenio" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                   value="{{ old('arsenio') }}"
                                   data-limite-max="{{ $limites['arsenio']->limite_maximo ?? 0.01 }}">
                            <small class="text-red-600 text-xs">Máx: {{ $limites['arsenio']->limite_maximo ?? 0.01 }} mg/L</small>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Mercúrio (Hg) - mg/L</label>
                            <input type="number" step="0.00001" name="mercurio" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 parametro-input"
                                   value="{{ old('mercurio') }}"
                                   data-limite-max="{{ $limites['mercurio']->limite_maximo ?? 0.001 }}">
                            <small class="text-red-600 text-xs">Máx: {{ $limites['mercurio']->limite_maximo ?? 0.001 }} mg/L</small>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-between">
                        <button type="button" class="bg-gray-500 text-white px-6 py-2 rounded-md hover:bg-gray-600 transition-colors" onclick="proximaEtapa(2)">
                            <i class="fas fa-arrow-left mr-2"></i>Voltar
                        </button>
                        <button type="button" class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors" onclick="proximaEtapa(4)">
                            Revisar <i class="fas fa-arrow-right ml-2"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Etapa 4: Revisão -->
        <div id="etapa4" class="etapa-content hidden">
            <div class="bg-white rounded-lg shadow">
                <div class="px-6 py-4 border-b border-gray-200 bg-green-50">
                    <h3 class="text-lg font-semibold text-gray-900">
                        <i class="fas fa-check-circle mr-2 text-green-600"></i>
                        Revisão dos Dados
                    </h3>
                </div>
                <div class="p-6">
                    <div class="bg-green-50 border-l-4 border-green-400 p-4 rounded mb-6">
                        <div class="flex">
                            <i class="fas fa-info-circle text-green-400 mt-0.5"></i>
                            <p class="ml-3 text-sm text-green-700">
                                Revise todos os dados antes de salvar. O IQA será calculado automaticamente.
                            </p>
                        </div>
                    </div>

                    <div id="resumoColeta" class="overflow-x-auto">
                        <!-- Preenchido via JavaScript -->
                    </div>

                    <div class="mt-6 flex justify-between">
                        <button type="button" class="bg-gray-500 text-white px-6 py-2 rounded-md hover:bg-gray-600 transition-colors" onclick="proximaEtapa(3)">
                            <i class="fas fa-arrow-left mr-2"></i>Voltar
                        </button>
                        <button type="submit" class="bg-green-600 text-white px-8 py-3 rounded-md hover:bg-green-700 transition-colors text-lg font-semibold">
                            <i class="fas fa-save mr-2"></i>Salvar e Calcular IQA
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
let etapaAtual = 1;

function mostrarEtapa(numero) {
    // Ocultar todas as etapas
    document.querySelectorAll('.etapa-content').forEach(etapa => {
        etapa.classList.add('hidden');
    });

    // Resetar todos os botões de navegação
    document.querySelectorAll('[data-etapa]').forEach(btn => {
        btn.classList.remove('bg-blue-600', 'text-white', 'font-semibold');
        btn.classList.add('bg-gray-200', 'text-gray-700');
    });

    // Mostrar etapa selecionada
    document.getElementById(`etapa${numero}`).classList.remove('hidden');

    // Destacar botão da etapa atual
    const btnAtual = document.getElementById(`etapa${numero}-tab`);
    btnAtual.classList.remove('bg-gray-200', 'text-gray-700');
    btnAtual.classList.add('bg-blue-600', 'text-white', 'font-semibold');

    etapaAtual = numero;

    if (numero === 4) {
        gerarResumo();
    }

    // Scroll para o topo
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

function proximaEtapa(numero) {
    mostrarEtapa(numero);
}

// Validação em tempo real
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.parametro-input').forEach(input => {
        input.addEventListener('input', function() {
            const valor = parseFloat(this.value);
            const limiteMin = parseFloat(this.dataset.limiteMin);
            const limiteMax = parseFloat(this.dataset.limiteMax);

            this.classList.remove('border-red-500', 'bg-yellow-50', 'border-green-500');

            if (!isNaN(valor)) {
                if ((!isNaN(limiteMin) && valor < limiteMin) || (!isNaN(limiteMax) && valor > limiteMax)) {
                    this.classList.add('border-red-500', 'bg-yellow-50');
                } else {
                    this.classList.add('border-green-500');
                }
            }
        });
    });
});

function gerarResumo() {
    const form = document.getElementById('formColeta');
    const formData = new FormData(form);

    let html = '<table class="min-w-full divide-y divide-gray-200 border border-gray-200">';
    html += '<thead class="bg-gray-800 text-white"><tr><th class="px-6 py-3 text-left text-xs font-medium uppercase">Parâmetro</th><th class="px-6 py-3 text-left text-xs font-medium uppercase">Valor</th></tr></thead>';
    html += '<tbody class="bg-white divide-y divide-gray-200">';

    for (let [key, value] of formData.entries()) {
        if (value && key !== '_token') {
            const inputElement = document.querySelector(`[name="${key}"]`);
            let label = key;

            if (inputElement) {
                const labelElement = inputElement.closest('div').querySelector('label');
                if (labelElement) {
                    label = labelElement.textContent.trim();
                }
            }

            html += `<tr class="hover:bg-gray-50"><td class="px-6 py-4 text-sm text-gray-700">${label}</td><td class="px-6 py-4 text-sm font-semibold text-gray-900">${value}</td></tr>`;
        }
    }

    html += '</tbody></table>';
    document.getElementById('resumoColeta').innerHTML = html;
}
</script>
@endsection
