@extends('layouts.app')

@section('title', 'Editar Coleta - QA Global')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-edit mr-3 text-yellow-600"></i>
                    Editar Coleta #{{ $coletaQa->id }}
                </h1>
                <p class="text-gray-600 mt-2">Atualize os dados e o IQA será recalculado automaticamente</p>
            </div>
            <a href="{{ route('qa-global.show', $coletaQa) }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Cancelar
            </a>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-50 border-l-4 border-red-400 p-4 rounded">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-exclamation-triangle text-red-400"></i>
                </div>
                <div class="ml-3">
                    <h3 class="text-sm font-medium text-red-800">Erros de Validação:</h3>
                    <ul class="mt-2 text-sm text-red-700 list-disc list-inside">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('qa-global.update', $coletaQa) }}" method="POST" id="formColeta">
        @csrf
        @method('PUT')

        <!-- Dados Gerais -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                    Dados Gerais da Coleta
                </h3>
            </div>
            <div class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div class="lg:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            Estação <span class="text-red-600">*</span>
                        </label>
                        <select name="estacao_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200" required>
                            <option value="">Selecione uma estação</option>
                            @foreach($estacoes as $estacao)
                                <option value="{{ $estacao->id }}" {{ old('estacao_id', $coletaQa->estacao_id) == $estacao->id ? 'selected' : '' }}>
                                    {{ $estacao->codigo }} - {{ $estacao->bacia_hidrografica->nome ?? '' }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            Data da Coleta <span class="text-red-600">*</span>
                        </label>
                        <input type="date" name="data_coleta" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('data_coleta', $coletaQa->data_coleta->format('Y-m-d')) }}" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Hora da Coleta</label>
                        <input type="time" name="hora_coleta" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('hora_coleta', $coletaQa->hora_coleta ? $coletaQa->hora_coleta->format('H:i') : '') }}">
                    </div>

                    <div class="lg:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Responsável pela Coleta</label>
                        <input type="text" name="responsavel" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('responsavel', $coletaQa->responsavel) }}" placeholder="Nome do responsável">
                    </div>

                    <div class="lg:col-span-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Observações</label>
                        <textarea name="observacoes" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                  rows="3" placeholder="Observações sobre a coleta">{{ old('observacoes', $coletaQa->observacoes) }}</textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Parâmetros Físico-Químicos -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200 bg-cyan-50">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-flask mr-2 text-cyan-600"></i>
                    Parâmetros Físico-Químicos
                </h3>
            </div>
            <div class="p-6">
                @php $params = $coletaQa->parametrosFisicoQuimicos; @endphp

                <!-- Parâmetros do IQA -->
                <div class="mb-6">
                    <h4 class="text-md font-semibold text-blue-700 border-b-2 border-blue-200 pb-2 mb-4">
                        <i class="fas fa-star mr-2"></i>Parâmetros do IQA
                    </h4>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Oxigênio Dissolvido (%)</label>
                            <input type="number" step="0.01" name="oxigenio_dissolvido" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('oxigenio_dissolvido', $params->oxigenio_dissolvido) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Coliformes Fecais (NMP/100mL)</label>
                            <input type="number" name="coliformes_fecais" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('coliformes_fecais', $params->coliformes_fecais) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">pH</label>
                            <input type="number" step="0.01" name="ph" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('ph', $params->ph) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">DBO (mg/L)</label>
                            <input type="number" step="0.01" name="dbo" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('dbo', $params->dbo) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Nitrogênio Total (mg/L)</label>
                            <input type="number" step="0.0001" name="nitrogenio_total" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('nitrogenio_total', $params->nitrogenio_total) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Fosfato Total (mg/L)</label>
                            <input type="number" step="0.0001" name="fosfato_total" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('fosfato_total', $params->fosfato_total) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Turbidez (NTU)</label>
                            <input type="number" step="0.01" name="turbidez" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('turbidez', $params->turbidez) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Sólidos Totais (mg/L)</label>
                            <input type="number" name="solidos_totais" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('solidos_totais', $params->solidos_totais) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Temperatura (°C)</label>
                            <input type="number" step="0.01" name="temperatura" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('temperatura', $params->temperatura) }}">
                        </div>
                    </div>
                </div>

                <!-- Parâmetros Adicionais -->
                <div class="mb-6">
                    <h4 class="text-md font-semibold text-gray-600 border-b-2 border-gray-200 pb-2 mb-4">
                        <i class="fas fa-plus mr-2"></i>Parâmetros Adicionais
                    </h4>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Condutividade Elétrica (µS/cm)</label>
                            <input type="number" name="condutividade_eletrica" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('condutividade_eletrica', $params->condutividade_eletrica) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">TDS (mg/L)</label>
                            <input type="number" name="tds" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('tds', $params->tds) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Nitrato (mg/L)</label>
                            <input type="number" step="0.0001" name="nitrato" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('nitrato', $params->nitrato) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Fosfato (mg/L)</label>
                            <input type="number" step="0.0001" name="fosfato" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('fosfato', $params->fosfato) }}">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Cloretos (mg/L)</label>
                            <input type="number" step="0.0001" name="cloretos" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                                   value="{{ old('cloretos', $params->cloretos) }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Metais Pesados -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200 bg-yellow-50">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-radiation mr-2 text-yellow-600"></i>
                    Metais Pesados
                </h3>
            </div>
            <div class="p-6">
                @php $metais = $coletaQa->metaisPesados; @endphp

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Ferro (Fe) - mg/L</label>
                        <input type="number" step="0.00001" name="ferro" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('ferro', $metais->ferro) }}">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Chumbo (Pb) - mg/L</label>
                        <input type="number" step="0.00001" name="chumbo" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('chumbo', $metais->chumbo) }}">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Cádmio (Cd) - mg/L</label>
                        <input type="number" step="0.000001" name="cadmio" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('cadmio', $metais->cadmio) }}">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Zinco (Zn) - mg/L</label>
                        <input type="number" step="0.00001" name="zinco" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('zinco', $metais->zinco) }}">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Cobre (Cu) - mg/L</label>
                        <input type="number" step="0.00001" name="cobre" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('cobre', $metais->cobre) }}">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Arsênio (As) - mg/L</label>
                        <input type="number" step="0.00001" name="arsenio" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('arsenio', $metais->arsenio) }}">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Mercúrio (Hg) - mg/L</label>
                        <input type="number" step="0.00001" name="mercurio" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200"
                               value="{{ old('mercurio', $metais->mercurio) }}">
                    </div>
                </div>
            </div>
        </div>

        <!-- Botões de Ação -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div class="flex space-x-3">
                    <button type="submit" class="bg-green-600 text-white px-8 py-3 rounded-md hover:bg-green-700 transition-colors text-lg font-semibold">
                        <i class="fas fa-save mr-2"></i>Salvar Alterações e Recalcular IQA
                    </button>
                    <a href="{{ route('qa-global.show', $coletaQa) }}" class="bg-gray-500 text-white px-6 py-3 rounded-md hover:bg-gray-600 transition-colors text-lg">
                        <i class="fas fa-times mr-2"></i>Cancelar
                    </a>
                </div>

                <form action="{{ route('qa-global.destroy', $coletaQa) }}" method="POST" class="inline"
                      onsubmit="return confirm('Tem certeza que deseja excluir esta coleta? Esta ação não pode ser desfeita.')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="bg-red-600 text-white px-6 py-3 rounded-md hover:bg-red-700 transition-colors text-lg">
                        <i class="fas fa-trash mr-2"></i>Excluir Coleta
                    </button>
                </form>
            </div>
        </div>
    </form>
</div>
@endsection
