@extends('layouts.app')

@section('title', 'Qualidade de Água Global')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-water mr-3 text-blue-600"></i>
                    Qualidade de Água Global
                </h1>
                <p class="text-gray-600 mt-2">Sistema de Processamento de Dados de Qualidade de Água</p>
            </div>
            <div class="flex space-x-4">
                <a href="{{ route('qa-global.dashboard') }}"
                   class="bg-purple-600 text-white px-4 py-2 rounded-md hover:bg-purple-700 transition-colors">
                    <i class="fas fa-chart-line mr-2"></i>
                    Dashboard IQA
                </a>
                <a href="{{ route('qa-global.graficos') }}"
                   class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 transition-colors">
                    <i class="fas fa-chart-bar mr-2"></i>
                    Gráficos
                </a>
                <a href="{{ route('qa-global.create') }}"
                   class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-plus mr-2"></i>
                    Nova Coleta
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-50 border-l-4 border-green-400 p-4 rounded">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-check-circle text-green-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-green-700">{{ session('success') }}</p>
                </div>
            </div>
        </div>
    @endif

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900 flex items-center">
                <i class="fas fa-filter mr-2 text-blue-600"></i>
                Filtros
            </h3>
        </div>
        <div class="p-6">
            <form method="GET" action="{{ route('qa-global.index') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Estação</label>
                    <select name="estacao_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                        <option value="">Todas as estações</option>
                        @foreach($estacoes as $estacao)
                            <option value="{{ $estacao->id }}" {{ request('estacao_id') == $estacao->id ? 'selected' : '' }}>
                                {{ $estacao->codigo }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                    <input type="date" name="data_inicio" value="{{ request('data_inicio') }}"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                    <input type="date" name="data_fim" value="{{ request('data_fim') }}"
                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Classificação IQA</label>
                    <select name="classificacao" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                        <option value="">Todas</option>
                        <option value="Excelente" {{ request('classificacao') == 'Excelente' ? 'selected' : '' }}>Excelente</option>
                        <option value="Boa" {{ request('classificacao') == 'Boa' ? 'selected' : '' }}>Boa</option>
                        <option value="Moderada" {{ request('classificacao') == 'Moderada' ? 'selected' : '' }}>Moderada</option>
                        <option value="Má" {{ request('classificacao') == 'Má' ? 'selected' : '' }}>Má</option>
                        <option value="Muito Má" {{ request('classificacao') == 'Muito Má' ? 'selected' : '' }}>Muito Má</option>
                    </select>
                </div>

                <div class="md:col-span-4 flex justify-between items-center">
                    <div class="flex space-x-2">
                        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                            <i class="fas fa-search mr-2"></i>
                            Filtrar
                        </button>
                        <a href="{{ route('qa-global.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                            <i class="fas fa-redo mr-2"></i>
                            Limpar
                        </a>
                    </div>
                    <div class="flex space-x-2">
                        <a href="{{ route('qa-global.exportar.excel', request()->all()) }}"
                           class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                            <i class="fas fa-file-excel mr-2"></i>
                            Excel
                        </a>
                        <a href="{{ route('qa-global.exportar.csv', request()->all()) }}"
                           class="bg-cyan-600 text-white px-4 py-2 rounded-md hover:bg-cyan-700 transition-colors">
                            <i class="fas fa-file-csv mr-2"></i>
                            CSV
                        </a>
                        <a href="{{ route('qa-global.exportar.pdf', request()->all()) }}"
                           class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition-colors">
                            <i class="fas fa-file-pdf mr-2"></i>
                            PDF
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Tabela de Coletas -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900 flex items-center">
                <i class="fas fa-list mr-2 text-blue-600"></i>
                Coletas Registradas ({{ $coletas->total() }})
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Estação</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Bacia</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Data</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Responsável</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">IQA</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Classificação</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($coletas as $coleta)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $coleta->id }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900">{{ $coleta->estacao->codigo }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $coleta->estacao->bacia_hidrografica->nome ?? '-' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                {{ $coleta->data_coleta->format('d/m/Y') }}
                                @if($coleta->hora_coleta)
                                    <br><span class="text-xs text-gray-400">{{ $coleta->hora_coleta->format('H:i') }}</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $coleta->responsavel ?? '-' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($coleta->iqaCalculado)
                                    <span class="text-lg font-bold" style="color: {{ $coleta->iqaCalculado->getCorClassificacao() }}">
                                        {{ number_format($coleta->iqaCalculado->iqa_valor, 2) }}
                                    </span>
                                @else
                                    <span class="text-sm text-gray-400">-</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($coleta->iqaCalculado)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium"
                                          style="background-color: {{ $coleta->iqaCalculado->getCorClassificacao() }}; color: white;">
                                        {{ $coleta->iqaCalculado->iqa_classificacao }}
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-200 text-gray-800">
                                        Sem IQA
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($coleta->validado)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        <i class="fas fa-check mr-1"></i> Validado
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                        <i class="fas fa-clock mr-1"></i> Pendente
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <div class="flex space-x-2">
                                    <a href="{{ route('qa-global.show', $coleta) }}"
                                       class="text-blue-600 hover:text-blue-900" title="Visualizar">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('qa-global.edit', $coleta) }}"
                                       class="text-yellow-600 hover:text-yellow-900" title="Editar">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="{{ route('qa-global.exportar.pdf', $coleta) }}"
                                       class="text-red-600 hover:text-red-900" title="PDF">
                                        <i class="fas fa-file-pdf"></i>
                                    </a>
                                    @if(!$coleta->validado)
                                        <form action="{{ route('qa-global.validar', $coleta) }}" method="POST" class="inline"
                                              onsubmit="return confirm('Confirmar validação desta coleta?')">
                                            @csrf
                                            <button type="submit" class="text-green-600 hover:text-green-900" title="Validar">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <i class="fas fa-inbox text-6xl text-gray-300 mb-4"></i>
                                    <p class="text-gray-500 text-lg mb-4">Nenhuma coleta encontrada</p>
                                    <a href="{{ route('qa-global.create') }}"
                                       class="bg-blue-600 text-white px-6 py-3 rounded-md hover:bg-blue-700 transition-colors">
                                        <i class="fas fa-plus mr-2"></i>
                                        Registrar Primeira Coleta
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($coletas->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $coletas->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
