@extends('layouts.app')

@section('title', 'Detalhes da Coleta - QA Global')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-eye mr-3 text-blue-600"></i>
                    Detalhes da Coleta #{{ $coletaQa->id }}
                </h1>
                <p class="text-gray-600 mt-2">{{ $coletaQa->estacao->codigo }} - {{ $coletaQa->data_coleta->format('d/m/Y') }}</p>
            </div>
            <div class="flex space-x-2">
                <a href="{{ route('qa-global.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>Voltar
                </a>
                <a href="{{ route('qa-global.edit', $coletaQa) }}" class="bg-yellow-500 text-white px-4 py-2 rounded-md hover:bg-yellow-600 transition-colors">
                    <i class="fas fa-edit mr-2"></i>Editar
                </a>
                <a href="{{ route('qa-global.exportar.pdf', $coletaQa) }}" class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition-colors">
                    <i class="fas fa-file-pdf mr-2"></i>PDF
                </a>
                @if(!$coletaQa->validado)
                    <form action="{{ route('qa-global.validar', $coletaQa) }}" method="POST" class="inline" onsubmit="return confirm('Validar esta coleta?')">
                        @csrf
                        <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                            <i class="fas fa-check mr-2"></i>Validar
                        </button>
                    </form>
                @endif
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-50 border-l-4 border-green-400 p-4 rounded">
            <div class="flex">
                <i class="fas fa-check-circle text-green-400"></i>
                <p class="ml-3 text-sm text-green-700">{{ session('success') }}</p>
            </div>
        </div>
    @endif

    <!-- Card IQA Destacado -->
    @if($coletaQa->iqaCalculado)
        <div class="rounded-lg shadow-lg p-8 text-white text-center" style="background: linear-gradient(135deg, {{ $coletaQa->iqaCalculado->getCorClassificacao() }} 0%, {{ $coletaQa->iqaCalculado->getCorClassificacao() }}dd 100%);">
            <h3 class="text-xl mb-2">Índice de Qualidade da Água (IQA)</h3>
            <h1 class="text-7xl font-bold my-4">{{ number_format($coletaQa->iqaCalculado->iqa_valor, 2) }}</h1>
            <h4 class="text-2xl font-semibold">{{ $coletaQa->iqaCalculado->iqa_classificacao }}</h4>
            <p class="mt-2 text-sm opacity-90">Calculado pelo método NSF-WQI</p>
        </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Informações Gerais -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                    Informações Gerais
                </h3>
            </div>
            <div class="p-6">
                <table class="min-w-full">
                    <tbody class="divide-y divide-gray-200">
                        <tr>
                            <td class="py-2 text-sm font-medium text-gray-500 w-1/2">ID:</td>
                            <td class="py-2 text-sm font-bold text-gray-900">#{{ $coletaQa->id }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-sm font-medium text-gray-500">Estação:</td>
                            <td class="py-2 text-sm font-bold text-gray-900">{{ $coletaQa->estacao->codigo }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-sm font-medium text-gray-500">Bacia:</td>
                            <td class="py-2 text-sm text-gray-700">{{ $coletaQa->estacao->bacia_hidrografica->nome ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-sm font-medium text-gray-500">Data Coleta:</td>
                            <td class="py-2 text-sm text-gray-700">{{ $coletaQa->data_coleta->format('d/m/Y') }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-sm font-medium text-gray-500">Hora Coleta:</td>
                            <td class="py-2 text-sm text-gray-700">{{ $coletaQa->hora_coleta ? $coletaQa->hora_coleta->format('H:i') : '-' }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-sm font-medium text-gray-500">Responsável:</td>
                            <td class="py-2 text-sm text-gray-700">{{ $coletaQa->responsavel ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-sm font-medium text-gray-500">Status:</td>
                            <td class="py-2">
                                @if($coletaQa->validado)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        <i class="fas fa-check mr-1"></i> Validado
                                    </span>
                                    <div class="mt-1 text-xs text-gray-500">
                                        Por: {{ $coletaQa->validadoPor->name ?? '-' }}<br>
                                        Em: {{ $coletaQa->data_validacao ? $coletaQa->data_validacao->format('d/m/Y H:i') : '' }}
                                    </div>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                        <i class="fas fa-clock mr-1"></i> Pendente
                                    </span>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>

                @if($coletaQa->observacoes)
                    <div class="mt-4 pt-4 border-t border-gray-200">
                        <h6 class="text-sm font-semibold text-gray-700 mb-2">Observações:</h6>
                        <p class="text-sm text-gray-600">{{ $coletaQa->observacoes }}</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Alertas de Conformidade -->
        <div class="lg:col-span-2 bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200 bg-yellow-50">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-exclamation-triangle mr-2 text-yellow-600"></i>
                    Alertas de Conformidade
                </h3>
            </div>
            <div class="p-6">
                @if(count($alertas) > 0)
                    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded mb-4">
                        <div class="flex">
                            <i class="fas fa-exclamation-circle text-yellow-400 mt-0.5"></i>
                            <p class="ml-3 text-sm font-semibold text-yellow-700">
                                {{ count($alertas) }} parâmetro(s) fora dos limites!
                            </p>
                        </div>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-800 text-white">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Parâmetro</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Valor Medido</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Severidade</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($alertas as $alerta)
                                    <tr class="hover:bg-gray-50 {{ $alerta['severidade'] == 'alta' ? 'bg-red-50' : ($alerta['severidade'] == 'media' ? 'bg-yellow-50' : 'bg-blue-50') }}">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900">{{ $alerta['parametro'] }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $alerta['valor'] }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-700">{{ $alerta['mensagem'] }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            @if($alerta['severidade'] == 'alta')
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">Alta</span>
                                            @elseif($alerta['severidade'] == 'media')
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">Média</span>
                                            @else
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">Baixa</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="bg-green-50 border-l-4 border-green-400 p-4 rounded">
                        <div class="flex">
                            <i class="fas fa-check-circle text-green-400"></i>
                            <p class="ml-3 text-sm text-green-700">Todos os parâmetros dentro dos limites aceitáveis!</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Parâmetros Físico-Químicos -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200 bg-cyan-50">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-flask mr-2 text-cyan-600"></i>
                Parâmetros Físico-Químicos
            </h3>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                @php
                    $params = $coletaQa->parametrosFisicoQuimicos;
                    $parametros = [
                        ['nome' => 'Oxigênio Dissolvido', 'campo' => 'oxigenio_dissolvido', 'unidade' => '%', 'limite_key' => null],
                        ['nome' => 'Coliformes Fecais', 'campo' => 'coliformes_fecais', 'unidade' => 'NMP/100mL', 'limite_key' => null],
                        ['nome' => 'pH', 'campo' => 'ph', 'unidade' => '', 'limite_key' => 'ph'],
                        ['nome' => 'DBO', 'campo' => 'dbo', 'unidade' => 'mg/L', 'limite_key' => null],
                        ['nome' => 'Nitrogênio Total', 'campo' => 'nitrogenio_total', 'unidade' => 'mg/L', 'limite_key' => null],
                        ['nome' => 'Fosfato Total', 'campo' => 'fosfato_total', 'unidade' => 'mg/L', 'limite_key' => 'fosfato'],
                        ['nome' => 'Turbidez', 'campo' => 'turbidez', 'unidade' => 'NTU', 'limite_key' => null],
                        ['nome' => 'Sólidos Totais', 'campo' => 'solidos_totais', 'unidade' => 'mg/L', 'limite_key' => null],
                        ['nome' => 'Temperatura', 'campo' => 'temperatura', 'unidade' => '°C', 'limite_key' => 'temperatura'],
                        ['nome' => 'Condutividade Elétrica', 'campo' => 'condutividade_eletrica', 'unidade' => 'µS/cm', 'limite_key' => 'condutividade_eletrica'],
                        ['nome' => 'TDS', 'campo' => 'tds', 'unidade' => 'mg/L', 'limite_key' => 'tds'],
                        ['nome' => 'Nitrato', 'campo' => 'nitrato', 'unidade' => 'mg/L', 'limite_key' => 'nitrato'],
                        ['nome' => 'Fosfato', 'campo' => 'fosfato', 'unidade' => 'mg/L', 'limite_key' => 'fosfato'],
                        ['nome' => 'Cloretos', 'campo' => 'cloretos', 'unidade' => 'mg/L', 'limite_key' => 'cloretos'],
                    ];
                @endphp

                @foreach($parametros as $param)
                    @if($params->{$param['campo']} !== null)
                        <div class="bg-gray-50 rounded-lg p-4 border border-gray-200">
                            <h6 class="text-xs font-medium text-gray-500 mb-2">{{ $param['nome'] }}</h6>
                            <h4 class="text-2xl font-bold text-gray-900">
                                {{ number_format($params->{$param['campo']}, 2) }}
                                <span class="text-sm font-normal text-gray-500">{{ $param['unidade'] }}</span>
                            </h4>
                            @if($param['limite_key'] && isset($limites[$param['limite_key']]))
                                <small class="text-xs text-gray-500">
                                    Limite: {{ $limites[$param['limite_key']]->limite_minimo ?? '' }}
                                    @if($limites[$param['limite_key']]->limite_minimo && $limites[$param['limite_key']]->limite_maximo) - @endif
                                    {{ $limites[$param['limite_key']]->limite_maximo ?? '' }}
                                    {{ $limites[$param['limite_key']]->unidade ?? '' }}
                                </small>
                            @endif
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>

    <!-- Metais Pesados -->
    @if($coletaQa->metaisPesados)
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200 bg-yellow-50">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-radiation mr-2 text-yellow-600"></i>
                    Metais Pesados
                </h3>
            </div>
            <div class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    @php
                        $metais = $coletaQa->metaisPesados;
                        $metaisLista = [
                            ['nome' => 'Ferro (Fe)', 'campo' => 'ferro', 'limite_key' => 'ferro'],
                            ['nome' => 'Chumbo (Pb)', 'campo' => 'chumbo', 'limite_key' => 'chumbo'],
                            ['nome' => 'Cádmio (Cd)', 'campo' => 'cadmio', 'limite_key' => 'cadmio'],
                            ['nome' => 'Zinco (Zn)', 'campo' => 'zinco', 'limite_key' => 'zinco'],
                            ['nome' => 'Cobre (Cu)', 'campo' => 'cobre', 'limite_key' => 'cobre'],
                            ['nome' => 'Arsênio (As)', 'campo' => 'arsenio', 'limite_key' => 'arsenio'],
                            ['nome' => 'Mercúrio (Hg)', 'campo' => 'mercurio', 'limite_key' => 'mercurio'],
                        ];
                    @endphp

                    @foreach($metaisLista as $metal)
                        @if($metais->{$metal['campo']} !== null)
                            @php
                                $valor = $metais->{$metal['campo']};
                                $limite = $limites[$metal['limite_key']] ?? null;
                                $excede = false;
                                if ($limite && $limite->limite_maximo && $valor > $limite->limite_maximo) {
                                    $excede = true;
                                }
                            @endphp
                            <div class="bg-gray-50 rounded-lg p-4 border {{ $excede ? 'border-red-500 bg-red-50' : 'border-gray-200' }}">
                                <h6 class="text-xs font-medium text-gray-500 mb-2">{{ $metal['nome'] }}</h6>
                                <h4 class="text-2xl font-bold {{ $excede ? 'text-red-600' : 'text-gray-900' }}">
                                    {{ number_format($valor, 5) }}
                                    <span class="text-sm font-normal text-gray-500">mg/L</span>
                                </h4>
                                @if($limite)
                                    <small class="text-xs {{ $excede ? 'text-red-600 font-semibold' : 'text-gray-500' }}">
                                        Máx: {{ $limite->limite_maximo }} mg/L
                                        @if($excede)
                                            <i class="fas fa-exclamation-triangle ml-1"></i>
                                        @endif
                                    </small>
                                @endif
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    <!-- Detalhes do Cálculo do IQA -->
    @if($coletaQa->iqaCalculado && $coletaQa->iqaCalculado->detalhes_calculo)
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200 bg-gray-100">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-calculator mr-2 text-gray-600"></i>
                    Detalhes do Cálculo do IQA
                </h3>
            </div>
            <div class="p-6">
                <p class="text-sm text-gray-600 mb-4">Subíndices (qi) calculados para cada parâmetro do IQA:</p>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-800 text-white">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Parâmetro</th>
                                <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Subíndice (qi)</th>
                                <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Peso</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @php
                                $pesos = [
                                    'od' => ['nome' => 'Oxigênio Dissolvido', 'peso' => 0.17],
                                    'cf' => ['nome' => 'Coliformes Fecais', 'peso' => 0.15],
                                    'ph' => ['nome' => 'pH', 'peso' => 0.12],
                                    'dbo' => ['nome' => 'DBO', 'peso' => 0.10],
                                    'n' => ['nome' => 'Nitrogênio Total', 'peso' => 0.10],
                                    'p' => ['nome' => 'Fosfato Total', 'peso' => 0.10],
                                    'turb' => ['nome' => 'Turbidez', 'peso' => 0.08],
                                    'sol' => ['nome' => 'Sólidos Totais', 'peso' => 0.08],
                                    'temp' => ['nome' => 'Temperatura', 'peso' => 0.10],
                                ];
                            @endphp

                            @foreach($coletaQa->iqaCalculado->detalhes_calculo as $key => $valor)
                                @if(isset($pesos[$key]))
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-6 py-4 text-sm text-gray-700">{{ $pesos[$key]['nome'] }}</td>
                                        <td class="px-6 py-4 text-sm font-bold text-gray-900">{{ number_format($valor, 2) }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-700">{{ $pesos[$key]['peso'] * 100 }}%</td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded mt-4">
                    <p class="text-xs text-blue-700">
                        <strong>Fórmula:</strong> IQA = ∏(qi^wi) onde qi = subíndice do parâmetro e wi = peso do parâmetro<br>
                        <strong>Método:</strong> NSF Water Quality Index (NSF-WQI)
                    </p>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
