@extends('layouts.app')

@section('title', 'Nova Coleta de Qualidade de Água')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-flask mr-3 text-blue-600"></i>
                    Nova Coleta de Qualidade de Água
                </h1>
                <p class="text-gray-600 mt-2">Registar dados de análise de qualidade de água</p>
            </div>
            <a href="{{ route('qualidade-agua.index') }}" class="text-gray-600 hover:text-gray-800">
                <i class="fas fa-arrow-left mr-2"></i> Voltar
            </a>
        </div>
    </div>

    <!-- Formulário -->
    <form action="{{ route('qualidade-agua.store') }}" method="POST">
        @csrf

        <!-- Informações Gerais -->
        <div class="bg-white rounded-lg shadow p-6 space-y-4">
            <h2 class="text-lg font-semibold text-gray-800 border-b pb-2">Informações Gerais</h2>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Barragem *</label>
                    <select name="barragem_id" class="w-full px-3 py-2 border border-gray-300 rounded-md @error('barragem_id') border-red-500 @enderror">
                        <option value="">Selecione uma barragem</option>
                        @foreach($barragens as $barragem)
                            <option value="{{ $barragem->id }}" {{ old('barragem_id') == $barragem->id ? 'selected' : '' }}>
                                {{ $barragem->nome }}
                            </option>
                        @endforeach
                    </select>
                    @error('barragem_id')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Estação</label>
                    <select name="estacao_id" class="w-full px-3 py-2 border border-gray-300 rounded-md">
                        <option value="">Selecione uma estação</option>
                        @foreach($estacoes as $estacao)
                            <option value="{{ $estacao->id }}" {{ old('estacao_id') == $estacao->id ? 'selected' : '' }}>
                                {{ $estacao->nome }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Data da Coleta *</label>
                    <input type="date" name="data_coleta" value="{{ old('data_coleta', date('Y-m-d')) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md @error('data_coleta') border-red-500 @enderror" required>
                    @error('data_coleta')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Hora da Coleta *</label>
                    <input type="time" name="hora_coleta" value="{{ old('hora_coleta', date('H:i')) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md @error('hora_coleta') border-red-500 @enderror" required>
                    @error('hora_coleta')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Local da Coleta</label>
                    <input type="text" name="local_coleta" value="{{ old('local_coleta') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Profundidade (m)</label>
                    <input type="number" step="0.01" name="profundidade_coleta" value="{{ old('profundidade_coleta') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>
            </div>
        </div>

        <!-- Parâmetros Físico-Químicos (IQA) -->
        <div class="bg-white rounded-lg shadow p-6 space-y-4">
            <h2 class="text-lg font-semibold text-gray-800 border-b pb-2">
                Parâmetros Físico-Químicos para Cálculo do IQA
            </h2>
            <p class="text-sm text-gray-600">Preencha os parâmetros disponíveis. O IQA será calculado automaticamente.</p>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Oxigênio Dissolvido (mg/L)
                    </label>
                    <input type="number" step="0.01" name="oxigenio_dissolvido" value="{{ old('oxigenio_dissolvido') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Coliformes Fecais (NMP/100mL)
                    </label>
                    <input type="number" step="0.01" name="coliformes_fecais" value="{{ old('coliformes_fecais') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">pH</label>
                    <input type="number" step="0.01" name="ph" value="{{ old('ph') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        DBO₅ (mg/L)
                    </label>
                    <input type="number" step="0.01" name="dbo5" value="{{ old('dbo5') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Nitrogênio Total (mg/L)
                    </label>
                    <input type="number" step="0.01" name="nitrogenio_total" value="{{ old('nitrogenio_total') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Fósforo Total (mg/L)
                    </label>
                    <input type="number" step="0.01" name="fosforo_total" value="{{ old('fosforo_total') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Temperatura (°C)
                    </label>
                    <input type="number" step="0.1" name="temperatura" value="{{ old('temperatura') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Turbidez (UNT)
                    </label>
                    <input type="number" step="0.01" name="turbidez" value="{{ old('turbidez') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Sólidos Totais (mg/L)
                    </label>
                    <input type="number" step="0.01" name="solidos_totais" value="{{ old('solidos_totais') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>
            </div>
        </div>

        <!-- Parâmetros Adicionais -->
        <div class="bg-white rounded-lg shadow p-6 space-y-4">
            <h2 class="text-lg font-semibold text-gray-800 border-b pb-2">Parâmetros Adicionais (Opcionais)</h2>

            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Condutividade (µS/cm)
                    </label>
                    <input type="number" step="0.01" name="condutividade" value="{{ old('condutividade') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Salinidade (ppt)
                    </label>
                    <input type="number" step="0.01" name="salinidade" value="{{ old('salinidade') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Clorofila-a (µg/L)
                    </label>
                    <input type="number" step="0.01" name="clorofila_a" value="{{ old('clorofila_a') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Transparência (m)
                    </label>
                    <input type="number" step="0.01" name="transparencia" value="{{ old('transparencia') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>
            </div>
        </div>

        <!-- Informações Complementares -->
        <div class="bg-white rounded-lg shadow p-6 space-y-4">
            <h2 class="text-lg font-semibold text-gray-800 border-b pb-2">Informações Complementares</h2>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Responsável pela Coleta</label>
                    <input type="text" name="responsavel_coleta" value="{{ old('responsavel_coleta') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Laboratório</label>
                    <input type="text" name="laboratorio" value="{{ old('laboratorio') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Data da Análise</label>
                    <input type="date" name="data_analise" value="{{ old('data_analise') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Observações</label>
                <textarea name="observacoes" rows="3"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md">{{ old('observacoes') }}</textarea>
            </div>
        </div>

        <!-- Botões -->
        <div class="bg-white rounded-lg shadow p-6 flex justify-end space-x-4">
            <a href="{{ route('qualidade-agua.index') }}"
               class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                Cancelar
            </a>
            <button type="submit"
                    class="px-6 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                <i class="fas fa-save mr-2"></i>
                Salvar e Calcular IQA
            </button>
        </div>
    </form>
</div>
@endsection
