@extends('layouts.app')

@section('title', 'Qualidade de Água')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-water mr-3 text-blue-600"></i>
                    Monitoramento de Qualidade de Água
                </h1>
                <p class="text-gray-600 mt-2">Gestão e análise do Índice de Qualidade de Água (IQA)</p>
            </div>
            <div class="flex space-x-4">
                <a href="{{ route('qualidade-agua.create') }}"
                   class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-plus mr-2"></i>
                    Nova Coleta
                </a>
                <a href="{{ route('qualidade-agua.estatisticas') }}"
                   class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                    <i class="fas fa-chart-bar mr-2"></i>
                    Estatísticas
                </a>
                <a href="{{ route('qualidade-agua.exportar', request()->all()) }}"
                   class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors">
                    <i class="fas fa-download mr-2"></i>
                    Exportar
                </a>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Barragem</label>
                <select name="barragem_id" class="w-full px-3 py-2 border border-gray-300 rounded-md">
                    <option value="">Todas</option>
                    @foreach($barragens as $barragem)
                        <option value="{{ $barragem->id }}" {{ request('barragem_id') == $barragem->id ? 'selected' : '' }}>
                            {{ $barragem->nome }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Estação</label>
                <select name="estacao_id" class="w-full px-3 py-2 border border-gray-300 rounded-md">
                    <option value="">Todas</option>
                    @foreach($estacoes as $estacao)
                        <option value="{{ $estacao->id }}" {{ request('estacao_id') == $estacao->id ? 'selected' : '' }}>
                            {{ $estacao->nome }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ request('data_inicio') }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-md">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                <input type="date" name="data_fim" value="{{ request('data_fim') }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-md">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Classificação</label>
                <select name="classificacao" class="w-full px-3 py-2 border border-gray-300 rounded-md">
                    <option value="">Todas</option>
                    <option value="excelente" {{ request('classificacao') == 'excelente' ? 'selected' : '' }}>Excelente</option>
                    <option value="boa" {{ request('classificacao') == 'boa' ? 'selected' : '' }}>Boa</option>
                    <option value="media" {{ request('classificacao') == 'media' ? 'selected' : '' }}>Média</option>
                    <option value="ruim" {{ request('classificacao') == 'ruim' ? 'selected' : '' }}>Ruim</option>
                    <option value="pessima" {{ request('classificacao') == 'pessima' ? 'selected' : '' }}>Péssima</option>
                </select>
            </div>

            <div class="md:col-span-5 flex justify-end space-x-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                    <i class="fas fa-search mr-2"></i>Filtrar
                </button>
                <a href="{{ route('qualidade-agua.index') }}" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md hover:bg-gray-300">
                    <i class="fas fa-times mr-2"></i>Limpar
                </a>
            </div>
        </form>
    </div>

    <!-- Tabela de Dados -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Local</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Data Coleta</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">IQA</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Classificação</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Validado</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($qualidades as $qualidade)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">
                                    {{ $qualidade->barragem->nome ?? $qualidade->estacao->nome ?? 'N/D' }}
                                </div>
                                <div class="text-sm text-gray-500">
                                    {{ $qualidade->local_coleta ?? '-' }}
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $qualidade->data_coleta->format('d/m/Y') }}
                                <span class="text-gray-500">{{ $qualidade->hora_coleta->format('H:i') }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-lg font-bold" style="color: {{ $qualidade->classificacao_cor }}">
                                    {{ $qualidade->iqa ?? 'N/C' }}
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($qualidade->classificacao_iqa)
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full"
                                          style="background-color: {{ $qualidade->classificacao_cor }}20; color: {{ $qualidade->classificacao_cor }}">
                                        {{ ucfirst($qualidade->classificacao_iqa) }}
                                    </span>
                                @else
                                    <span class="text-gray-400">-</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($qualidade->validado)
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                        <i class="fas fa-check mr-1"></i> Sim
                                    </span>
                                @else
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                        <i class="fas fa-clock mr-1"></i> Pendente
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('qualidade-agua.show', $qualidade) }}"
                                   class="text-blue-600 hover:text-blue-900 mr-3">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('qualidade-agua.edit', $qualidade) }}"
                                   class="text-yellow-600 hover:text-yellow-900 mr-3">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if(!$qualidade->validado)
                                    <form action="{{ route('qualidade-agua.validar', $qualidade) }}"
                                          method="POST" class="inline">
                                        @csrf
                                        <button type="submit" class="text-green-600 hover:text-green-900">
                                            <i class="fas fa-check-circle"></i>
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                                <i class="fas fa-inbox text-4xl mb-4 text-gray-300"></i>
                                <p>Nenhum registro de qualidade de água encontrado.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Paginação -->
        @if($qualidades->hasPages())
            <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                {{ $qualidades->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
