@extends('layouts.app')

@section('title', 'Detalhes da Qualidade de Água')

@section('content')
<div class="max-w-6xl mx-auto space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-water mr-3 text-blue-600"></i>
                    Análise de Qualidade de Água
                </h1>
                <p class="text-gray-600 mt-2">
                    {{ $qualidadeAgua->barragem->nome ?? $qualidadeAgua->estacao->nome ?? 'N/D' }}
                </p>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('qualidade-agua.index') }}" class="text-gray-600 hover:text-gray-800">
                    <i class="fas fa-arrow-left mr-2"></i> Voltar
                </a>
                <a href="{{ route('qualidade-agua.edit', $qualidadeAgua) }}"
                   class="bg-yellow-600 text-white px-4 py-2 rounded-md hover:bg-yellow-700">
                    <i class="fas fa-edit mr-2"></i> Editar
                </a>
            </div>
        </div>
    </div>

    <!-- Resultado do IQA -->
    <div class="bg-gradient-to-r from-blue-50 to-cyan-50 rounded-lg shadow p-8">
        <div class="text-center">
            <h2 class="text-sm font-medium text-gray-600 uppercase tracking-wide mb-2">
                Índice de Qualidade de Água (IQA)
            </h2>
            <div class="text-6xl font-bold mb-2" style="color: {{ $qualidadeAgua->classificacao_cor }}">
                {{ $qualidadeAgua->iqa ?? 'N/C' }}
            </div>
            <div class="inline-flex items-center px-4 py-2 rounded-full text-lg font-semibold"
                 style="background-color: {{ $qualidadeAgua->classificacao_cor }}20; color: {{ $qualidadeAgua->classificacao_cor }}">
                {{ ucfirst($qualidadeAgua->classificacao_iqa ?? 'Não calculado') }}
            </div>
            <p class="text-sm text-gray-600 mt-4">
                {{ $qualidadeAgua->classificacao_descricao }}
            </p>
        </div>
    </div>

    <!-- Informações da Coleta -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Dados da Coleta</h3>
            <dl class="space-y-3">
                <div class="flex justify-between">
                    <dt class="text-gray-600">Data/Hora:</dt>
                    <dd class="font-medium">{{ $qualidadeAgua->data_coleta->format('d/m/Y') }} {{ $qualidadeAgua->hora_coleta->format('H:i') }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-600">Local:</dt>
                    <dd class="font-medium">{{ $qualidadeAgua->local_coleta ?? '-' }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-600">Profundidade:</dt>
                    <dd class="font-medium">{{ $qualidadeAgua->profundidade_coleta ? $qualidadeAgua->profundidade_coleta . ' m' : '-' }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-600">Responsável:</dt>
                    <dd class="font-medium">{{ $qualidadeAgua->responsavel_coleta ?? '-' }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-600">Laboratório:</dt>
                    <dd class="font-medium">{{ $qualidadeAgua->laboratorio ?? '-' }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-600">Data Análise:</dt>
                    <dd class="font-medium">{{ $qualidadeAgua->data_analise ? $qualidadeAgua->data_analise->format('d/m/Y') : '-' }}</dd>
                </div>
            </dl>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Status</h3>
            <dl class="space-y-3">
                <div class="flex justify-between items-center">
                    <dt class="text-gray-600">Validado:</dt>
                    <dd>
                        @if($qualidadeAgua->validado)
                            <span class="px-3 py-1 rounded-full bg-green-100 text-green-800 font-medium">
                                <i class="fas fa-check-circle mr-1"></i> Sim
                            </span>
                        @else
                            <span class="px-3 py-1 rounded-full bg-yellow-100 text-yellow-800 font-medium">
                                <i class="fas fa-clock mr-1"></i> Pendente
                            </span>
                        @endif
                    </dd>
                </div>
                @if($qualidadeAgua->validado)
                    <div class="flex justify-between">
                        <dt class="text-gray-600">Validado por:</dt>
                        <dd class="font-medium">{{ $qualidadeAgua->validadoPor->name ?? '-' }}</dd>
                    </div>
                    <div class="flex justify-between">
                        <dt class="text-gray-600">Data Validação:</dt>
                        <dd class="font-medium">{{ $qualidadeAgua->data_validacao ? $qualidadeAgua->data_validacao->format('d/m/Y H:i') : '-' }}</dd>
                    </div>
                @else
                    <div class="mt-4">
                        <form action="{{ route('qualidade-agua.validar', $qualidadeAgua) }}" method="POST">
                            @csrf
                            <button type="submit" class="w-full bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700">
                                <i class="fas fa-check-circle mr-2"></i> Validar Análise
                            </button>
                        </form>
                    </div>
                @endif
            </dl>
        </div>
    </div>

    <!-- Parâmetros Físico-Químicos -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Parâmetros Físico-Químicos (IQA)</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Oxigênio Dissolvido</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->oxigenio_dissolvido ?? '-' }} <span class="text-sm font-normal text-gray-600">mg/L</span></div>
            </div>
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Coliformes Fecais</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->coliformes_fecais ?? '-' }} <span class="text-sm font-normal text-gray-600">NMP/100mL</span></div>
            </div>
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">pH</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->ph ?? '-' }}</div>
            </div>
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">DBO₅</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->dbo5 ?? '-' }} <span class="text-sm font-normal text-gray-600">mg/L</span></div>
            </div>
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Nitrogênio Total</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->nitrogenio_total ?? '-' }} <span class="text-sm font-normal text-gray-600">mg/L</span></div>
            </div>
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Fósforo Total</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->fosforo_total ?? '-' }} <span class="text-sm font-normal text-gray-600">mg/L</span></div>
            </div>
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Temperatura</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->temperatura ?? '-' }} <span class="text-sm font-normal text-gray-600">°C</span></div>
            </div>
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Turbidez</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->turbidez ?? '-' }} <span class="text-sm font-normal text-gray-600">UNT</span></div>
            </div>
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Sólidos Totais</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->solidos_totais ?? '-' }} <span class="text-sm font-normal text-gray-600">mg/L</span></div>
            </div>
        </div>
    </div>

    <!-- Parâmetros Adicionais -->
    @if($qualidadeAgua->condutividade || $qualidadeAgua->salinidade || $qualidadeAgua->clorofila_a || $qualidadeAgua->transparencia)
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Parâmetros Adicionais</h3>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            @if($qualidadeAgua->condutividade)
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Condutividade</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->condutividade }} <span class="text-sm font-normal text-gray-600">µS/cm</span></div>
            </div>
            @endif
            @if($qualidadeAgua->salinidade)
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Salinidade</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->salinidade }} <span class="text-sm font-normal text-gray-600">ppt</span></div>
            </div>
            @endif
            @if($qualidadeAgua->clorofila_a)
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Clorofila-a</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->clorofila_a }} <span class="text-sm font-normal text-gray-600">µg/L</span></div>
            </div>
            @endif
            @if($qualidadeAgua->transparencia)
            <div class="p-4 bg-gray-50 rounded-lg">
                <div class="text-sm text-gray-600">Transparência</div>
                <div class="text-lg font-bold">{{ $qualidadeAgua->transparencia }} <span class="text-sm font-normal text-gray-600">m</span></div>
            </div>
            @endif
        </div>
    </div>
    @endif

    <!-- Observações -->
    @if($qualidadeAgua->observacoes)
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Observações</h3>
        <p class="text-gray-700">{{ $qualidadeAgua->observacoes }}</p>
    </div>
    @endif

    <!-- Ações -->
    <div class="bg-white rounded-lg shadow p-6 flex justify-between">
        <form action="{{ route('qualidade-agua.recalcular-iqa', $qualidadeAgua) }}" method="POST">
            @csrf
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                <i class="fas fa-calculator mr-2"></i> Recalcular IQA
            </button>
        </form>

        <form action="{{ route('qualidade-agua.destroy', $qualidadeAgua) }}" method="POST"
              onsubmit="return confirm('Tem certeza que deseja excluir este registro?')">
            @csrf
            @method('DELETE')
            <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700">
                <i class="fas fa-trash mr-2"></i> Excluir
            </button>
        </form>
    </div>
</div>
@endsection
