<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Sistema Hidrológico de Moçambique</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-gray-50">
    <!-- Header -->
    <header class="bg-blue-900 text-white">
        <div class="container mx-auto px-6 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <i class="fas fa-water text-3xl mr-4"></i>
                    <div>
                        <h1 class="text-2xl font-bold">Sistema Hidrológico</h1>
                        <p class="text-blue-200">República de Moçambique</p>
                    </div>
                </div>
                <div class="flex space-x-4">
                    @auth
                        <a href="{{ route('dashboard') }}" class="bg-blue-700 px-4 py-2 rounded hover:bg-blue-600">
                            <i class="fas fa-chart-line mr-2"></i>Dashboard
                        </a>
                    @else
                        <a href="{{ route('login') }}" class="bg-blue-700 px-4 py-2 rounded hover:bg-blue-600">
                            <i class="fas fa-sign-in-alt mr-2"></i>Entrar
                        </a>
                    @endauth
                </div>
            </div>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-blue-600 to-blue-800 text-white py-20">
        <div class="container mx-auto px-6 text-center">
            <h2 class="text-5xl font-bold mb-6">Monitoramento de Recursos Hídricos</h2>
            <p class="text-xl mb-8 max-w-3xl mx-auto">
                Sistema integrado para gestão e monitoramento de barragens, estações hidrométricas e 
                recursos hídricos de Moçambique em tempo real.
            </p>
            <div class="flex justify-center space-x-6">
                @auth
                    <a href="{{ route('dashboard') }}" class="bg-white text-blue-800 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100">
                        Acessar Sistema
                    </a>
                @else
                    <a href="{{ route('login') }}" class="bg-white text-blue-800 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100">
                        Fazer Login
                    </a>
                @endauth
            </div>
        </div>
    </section>

    <!-- Features -->
    <section class="py-20">
        <div class="container mx-auto px-6">
            <h3 class="text-3xl font-bold text-center mb-12">Funcionalidades Principais</h3>
            <div class="grid md:grid-cols-3 gap-8">
                <div class="text-center">
                    <div class="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-water text-blue-600 text-2xl"></i>
                    </div>
                    <h4 class="text-xl font-semibold mb-2">Gestão de Barragens</h4>
                    <p class="text-gray-600">Monitoramento de 6 barragens principais com dados em tempo real</p>
                </div>
                <div class="text-center">
                    <div class="bg-green-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-broadcast-tower text-green-600 text-2xl"></i>
                    </div>
                    <h4 class="text-xl font-semibold mb-2">Rede de Estações</h4>
                    <p class="text-gray-600">15+ estações hidrométricas e pluviométricas distribuídas</p>
                </div>
                <div class="text-center">
                    <div class="bg-purple-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-file-alt text-purple-600 text-2xl"></i>
                    </div>
                    <h4 class="text-xl font-semibold mb-2">Boletins Automáticos</h4>
                    <p class="text-gray-600">Geração automática de relatórios e boletins hidrológicos</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="bg-blue-50 py-16">
        <div class="container mx-auto px-6">
            <div class="grid md:grid-cols-4 gap-8 text-center">
                <div>
                    <div class="text-3xl font-bold text-blue-600">6</div>
                    <div class="text-gray-600">Barragens Principais</div>
                </div>
                <div>
                    <div class="text-3xl font-bold text-green-600">15+</div>
                    <div class="text-gray-600">Estações Activas</div>
                </div>
                <div>
                    <div class="text-3xl font-bold text-purple-600">8</div>
                    <div class="text-gray-600">Bacias Hidrográficas</div>
                </div>
                <div>
                    <div class="text-3xl font-bold text-orange-600">24/7</div>
                    <div class="text-gray-600">Monitoramento</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-8">
        <div class="container mx-auto px-6 text-center">
            <p>&copy; 2025 Sistema Hidrológico de Moçambique. Todos os direitos reservados.</p>
            <p class="text-gray-400 mt-2">Ministério das Obras Públicas e Habitação</p>
        </div>
    </footer>
</body>
